/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.internal.loader.DefaultLoaderListener;
import org.javamoney.moneta.internal.loader.LoadableResource;

class ScheduledDataLoaderService {
    private static final Logger LOG = Logger.getLogger(ScheduledDataLoaderService.class.getName());
    private final Timer timer;
    private final DefaultLoaderListener listener;

    ScheduledDataLoaderService(Timer timer, DefaultLoaderListener listener) {
        this.timer = timer;
        this.listener = listener;
    }

    public void execute(final LoadableResource load) {
        Objects.requireNonNull(load);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (load.load()) {
                        ScheduledDataLoaderService.this.listener.trigger(load.getResourceId(), load.getDataStream());
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to update remote resource: " + load.getResourceId(), e);
                }
            }
        };
        Map<String, String> props = load.getProperties();
        if (Objects.nonNull(props)) {
            String value = props.get("period");
            long periodMS = this.parseDuration(value);
            value = props.get("delay");
            long delayMS = this.parseDuration(value);
            if (periodMS > 0L) {
                this.timer.scheduleAtFixedRate(task, delayMS, periodMS);
            } else {
                value = props.get("at");
                if (Objects.nonNull(value)) {
                    List<GregorianCalendar> dates = this.parseDates(value);
                    dates.forEach(date -> this.timer.schedule(task, date.getTime(), 86400000L));
                }
            }
        }
    }

    private List<GregorianCalendar> parseDates(String value) {
        String[] parts = value.split(",");
        ArrayList<GregorianCalendar> result = new ArrayList<GregorianCalendar>();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            String[] subparts = part.split(":");
            GregorianCalendar cal = new GregorianCalendar();
            block7: for (int i = 0; i < subparts.length; ++i) {
                switch (i) {
                    case 0: {
                        cal.set(11, Integer.parseInt(subparts[i]));
                        continue block7;
                    }
                    case 1: {
                        cal.set(12, Integer.parseInt(subparts[i]));
                        continue block7;
                    }
                    case 2: {
                        cal.set(13, Integer.parseInt(subparts[i]));
                        continue block7;
                    }
                    case 3: {
                        cal.set(14, Integer.parseInt(subparts[i]));
                    }
                }
            }
            result.add(cal);
        }
        return result;
    }

    private long parseDuration(String value) {
        long periodMS = 0L;
        if (Objects.nonNull(value)) {
            String[] parts = value.split(":");
            block6: for (int i = 0; i < parts.length; ++i) {
                switch (i) {
                    case 0: {
                        periodMS += (long)Integer.parseInt(parts[i]) * 3600000L;
                        continue block6;
                    }
                    case 1: {
                        periodMS += (long)Integer.parseInt(parts[i]) * 60000L;
                        continue block6;
                    }
                    case 2: {
                        periodMS += (long)Integer.parseInt(parts[i]) * 1000L;
                        continue block6;
                    }
                    case 3: {
                        periodMS += (long)Integer.parseInt(parts[i]);
                        continue block6;
                    }
                }
            }
        }
        return periodMS;
    }

    public String toString() {
        return ScheduledDataLoaderService.class.getName() + '{' + " timer: " + this.timer + '}';
    }
}

