/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.factory;

import org.apache.http.client.HttpClient;
import org.javaswift.joss.client.factory.AccountConfig;
import org.javaswift.joss.client.factory.AuthenticationMethod;
import org.javaswift.joss.command.impl.identity.BasicAuthenticationCommandImpl;
import org.javaswift.joss.command.impl.identity.ExternalAuthenticationCommandImpl;
import org.javaswift.joss.command.impl.identity.KeystoneAuthenticationCommandImpl;
import org.javaswift.joss.command.impl.identity.KeystoneAuthenticationV3CommandImpl;
import org.javaswift.joss.command.impl.identity.TempAuthAuthenticationCommandImpl;
import org.javaswift.joss.command.shared.factory.AuthenticationCommandFactory;
import org.javaswift.joss.command.shared.identity.AuthenticationCommand;

public class AuthenticationCommandFactoryImpl
implements AuthenticationCommandFactory {
    @Override
    public AuthenticationCommand createAuthenticationCommand(HttpClient httpClient, AccountConfig config) {
        String url = config.getAuthUrl();
        String tenantName = config.getTenantName();
        String username = config.getUsername();
        String password = config.getPassword();
        if (config.getAuthenticationMethod() == AuthenticationMethod.BASIC) {
            return new BasicAuthenticationCommandImpl(httpClient, url, username, password, tenantName);
        }
        if (config.getAuthenticationMethod() == AuthenticationMethod.TEMPAUTH) {
            return new TempAuthAuthenticationCommandImpl(httpClient, url, username, password, tenantName);
        }
        if (config.getAuthenticationMethod() == AuthenticationMethod.EXTERNAL) {
            return new ExternalAuthenticationCommandImpl(httpClient, url, config.getAccessProvider());
        }
        if (config.getAuthenticationMethod() == AuthenticationMethod.KEYSTONE_V3) {
            return new KeystoneAuthenticationV3CommandImpl(httpClient, config);
        }
        return new KeystoneAuthenticationCommandImpl(httpClient, url, tenantName, config.getTenantId(), username, password);
    }
}

