/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.shared.identity.access;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.codehaus.jackson.JsonNode;
import org.javaswift.joss.client.factory.TempUrlHashPrefixSource;
import org.javaswift.joss.command.shared.identity.access.EndPoint;
import org.javaswift.joss.model.Access;

public class KeystoneV3Access
implements Access {
    private final String token;
    private final Collection<EndPoint> endPoints;
    private EndPoint currentEndpoint;

    public KeystoneV3Access(String token, JsonNode response) {
        this.token = token;
        this.endPoints = this.getEndPoints(response);
        this.currentEndpoint = this.getEndPoint(null);
    }

    @Override
    public void setPreferredRegion(String preferredRegion) {
        this.currentEndpoint = this.getEndPoint(preferredRegion);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getInternalURL() {
        return this.currentEndpoint.internalURL;
    }

    @Override
    public String getPublicURL() {
        return this.currentEndpoint.publicURL;
    }

    @Override
    public boolean isTenantSupplied() {
        return true;
    }

    @Override
    public String getTempUrlPrefix(TempUrlHashPrefixSource tempUrlHashPrefixSource) {
        String tempUrlPrefix = tempUrlHashPrefixSource == null ? "" : (tempUrlHashPrefixSource == TempUrlHashPrefixSource.PUBLIC_URL_PATH ? TempUrlHashPrefixSource.getPath(this.currentEndpoint.publicURL) : (tempUrlHashPrefixSource == TempUrlHashPrefixSource.INTERNAL_URL_PATH ? TempUrlHashPrefixSource.getPath(this.currentEndpoint.internalURL) : TempUrlHashPrefixSource.getPath(this.currentEndpoint.adminURL)));
        return tempUrlPrefix.endsWith("/") ? tempUrlPrefix.substring(0, tempUrlPrefix.length() - 1) : tempUrlPrefix;
    }

    private EndPoint getEndPoint(String region) {
        if (this.endPoints.isEmpty()) {
            throw new IllegalStateException("No endpoints available");
        }
        if (region == null) {
            return this.endPoints.iterator().next();
        }
        for (EndPoint endPoint : this.endPoints) {
            if (!region.equals(endPoint.region)) continue;
            return endPoint;
        }
        throw new IllegalArgumentException("No endpoint for region: " + region);
    }

    private Collection<EndPoint> getEndPoints(JsonNode response) {
        LinkedHashMap<String, EndPoint> result = new LinkedHashMap<String, EndPoint>();
        JsonNode token = response.get("token");
        for (JsonNode catalog : token.get("catalog")) {
            if (!"object-store".equals(catalog.get("type").asText())) continue;
            for (JsonNode endpointNode : catalog.get("endpoints")) {
                String interfaceType = endpointNode.get("interface").asText();
                String url = endpointNode.get("url").asText();
                String region = endpointNode.get("region").asText();
                EndPoint endPoint = (EndPoint)result.get(region);
                if (endPoint == null) {
                    endPoint = new EndPoint();
                    endPoint.region = region;
                    result.put(region, endPoint);
                }
                if ("public".equals(interfaceType)) {
                    endPoint.publicURL = url;
                    continue;
                }
                if ("admin".equals(interfaceType)) {
                    endPoint.adminURL = url;
                    continue;
                }
                if (!"internal".equals(interfaceType)) continue;
                endPoint.internalURL = url;
            }
        }
        return result.values();
    }
}

