/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.exception;

import java.lang.reflect.Constructor;
import org.javaswift.joss.exception.AlreadyExistsException;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.exception.CommandExceptionError;
import org.javaswift.joss.exception.ForbiddenException;
import org.javaswift.joss.exception.Md5ChecksumException;
import org.javaswift.joss.exception.MissingContentLengthOrTypeException;
import org.javaswift.joss.exception.ModifiedException;
import org.javaswift.joss.exception.NotEmptyException;
import org.javaswift.joss.exception.NotFoundException;
import org.javaswift.joss.exception.NotModifiedException;
import org.javaswift.joss.exception.UnauthorizedException;

public enum HttpStatusToExceptionMapper {
    _202(202, CommandExceptionError.ENTITY_ALREADY_EXISTS, AlreadyExistsException.class),
    _401(401, CommandExceptionError.UNAUTHORIZED, UnauthorizedException.class),
    _403(403, CommandExceptionError.ACCESS_FORBIDDEN, ForbiddenException.class),
    _404(404, CommandExceptionError.ENTITY_DOES_NOT_EXIST, NotFoundException.class),
    _304(304, CommandExceptionError.CONTENT_NOT_MODIFIED, NotModifiedException.class),
    _409(409, CommandExceptionError.CONTAINER_NOT_EMPTY, NotEmptyException.class),
    _411(411, CommandExceptionError.MISSING_CONTENT_LENGTH_OR_TYPE, MissingContentLengthOrTypeException.class),
    _412(412, CommandExceptionError.CONTENT_DIFFERENT, ModifiedException.class),
    _422(422, CommandExceptionError.MD5_CHECKSUM, Md5ChecksumException.class);

    private final int httpStatus;
    private final CommandExceptionError error;
    protected Class<? extends CommandException> exceptionToThrow;

    private HttpStatusToExceptionMapper(int httpStatus, CommandExceptionError error, Class<? extends CommandException> exceptionToThrow) {
        this.httpStatus = httpStatus;
        this.error = error;
        this.exceptionToThrow = exceptionToThrow;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Class<? extends CommandException> getExceptionToThrow() {
        return this.exceptionToThrow;
    }

    public CommandExceptionError getError() {
        return this.error;
    }

    public CommandException getException(CommandExceptionError customError) {
        CommandExceptionError showError = customError == null ? this.getError() : customError;
        try {
            Constructor<? extends CommandException> constructor = this.getExceptionToThrow().getDeclaredConstructor(Integer.class, CommandExceptionError.class);
            Object[] arguments = new Object[]{this.getHttpStatus(), showError};
            return constructor.newInstance(arguments);
        }
        catch (Exception err) {
            return new CommandException("Programming error - unable to throw exception for " + this.getHttpStatus() + "/" + (Object)((Object)customError), err);
        }
    }
}

