/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.headers.account;

import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.javaswift.joss.headers.Metadata;

public class AccountMetadata
extends Metadata {
    public static final String X_ACCOUNT_META_PREFIX = "X-Account-Meta-";

    public AccountMetadata(String name, String value) {
        super(name, value);
    }

    @Override
    public String getHeaderName() {
        return X_ACCOUNT_META_PREFIX + this.getName();
    }

    public static Map<String, Metadata> fromResponse(HttpResponse response) {
        TreeMap<String, Metadata> metadata = new TreeMap<String, Metadata>();
        for (Header header : AccountMetadata.getResponseHeadersStartingWith(response, X_ACCOUNT_META_PREFIX)) {
            AccountMetadata accountMetadata = new AccountMetadata(header.getName().substring(X_ACCOUNT_META_PREFIX.length()), header.getValue());
            metadata.put(accountMetadata.getName(), accountMetadata);
        }
        return metadata;
    }
}

