/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.headers.container;

import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.javaswift.joss.headers.Metadata;

public class ContainerMetadata
extends Metadata {
    public static final String X_CONTAINER_META_PREFIX = "X-Container-Meta-";

    public ContainerMetadata(String name, String value) {
        super(name, value);
    }

    @Override
    public String getHeaderName() {
        return X_CONTAINER_META_PREFIX + this.getName();
    }

    public static Map<String, Metadata> fromResponse(HttpResponse response) {
        TreeMap<String, Metadata> metadata = new TreeMap<String, Metadata>();
        for (Header header : ContainerMetadata.getResponseHeadersStartingWith(response, X_CONTAINER_META_PREFIX)) {
            ContainerMetadata containerMetadata = new ContainerMetadata(header.getName().substring(X_CONTAINER_META_PREFIX.length()), header.getValue());
            metadata.put(containerMetadata.getName(), containerMetadata);
        }
        return metadata;
    }
}

