/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.object.DeleteAfter;
import org.javaswift.joss.headers.object.DeleteAt;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.headers.object.ObjectContentLength;
import org.javaswift.joss.headers.object.ObjectContentType;
import org.javaswift.joss.headers.object.ObjectLastModified;
import org.javaswift.joss.headers.object.ObjectManifest;
import org.javaswift.joss.information.AbstractInformation;

public class ObjectInformation
extends AbstractInformation {
    private ObjectLastModified lastModified;
    private Etag etag;
    private ObjectContentLength contentLength;
    private ObjectContentType contentType;
    private DeleteAfter deleteAfter;
    private DeleteAt deleteAt;
    private ObjectManifest manifest;

    public Date getLastModifiedAsDate() {
        return this.lastModified == null ? null : this.lastModified.getDate();
    }

    public String getLastModified() {
        return this.lastModified == null ? null : this.lastModified.getHeaderValue();
    }

    public void setLastModified(ObjectLastModified lastModified) {
        this.lastModified = lastModified;
    }

    public String getEtag() {
        return this.etag.getHeaderValue();
    }

    public void setEtag(Etag etag) {
        this.etag = etag;
    }

    public long getContentLength() {
        return Long.parseLong(this.contentLength.getHeaderValue());
    }

    public void setContentLength(ObjectContentLength contentLength) {
        this.contentLength = contentLength;
    }

    public Header getContentTypeHeader() {
        return this.contentType;
    }

    public String getContentType() {
        return this.contentType.getHeaderValue();
    }

    public void setContentType(ObjectContentType contentType) {
        this.contentType = contentType;
    }

    public void setDeleteAt(DeleteAt deleteAt) {
        this.deleteAt = deleteAt;
    }

    public DeleteAt getDeleteAt() {
        return this.deleteAt;
    }

    public void setDeleteAfter(DeleteAfter deleteAfter) {
        this.deleteAfter = deleteAfter;
    }

    public DeleteAfter getDeleteAfter() {
        return this.deleteAfter;
    }

    public void addHeader(Collection<Header> headers, Header header) {
        if (header == null) {
            return;
        }
        headers.add(header);
    }

    public String getManifest() {
        return this.manifest == null ? null : this.manifest.getHeaderValue();
    }

    public void setManifest(ObjectManifest manifest) {
        this.manifest = manifest;
    }

    protected ObjectManifest getObjectManifest() {
        return this.manifest;
    }

    public Collection<Header> getHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        this.addHeader(headers, this.getDeleteAfter());
        this.addHeader(headers, this.getDeleteAt());
        this.addHeader(headers, this.getObjectManifest());
        headers.addAll(this.getMetadata());
        return headers;
    }

    public Collection<Header> getHeadersIncludingHeader(Header header) {
        Collection<Header> headers = this.getHeaders();
        this.addHeader(headers, header);
        return headers;
    }
}

