/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.model;

import org.javaswift.joss.model.DirectoryOrObject;
import org.javaswift.joss.model.StoredObject;

public class Directory
implements Comparable<DirectoryOrObject>,
DirectoryOrObject {
    private final String path;
    private final String bareName;

    public Directory(String path, Character delimiter) {
        this.path = path;
        this.bareName = Directory.bareName(path, delimiter);
    }

    public static String bareName(String name, Character delimiter) {
        if (name == null) {
            return null;
        }
        int lastSlash = name.lastIndexOf(delimiter.charValue());
        if (lastSlash != -1 && lastSlash == name.length() - 1) {
            name = name.substring(0, name.length() - 1);
        }
        if ((lastSlash = name.lastIndexOf(delimiter.charValue())) != -1) {
            name = name.substring(lastSlash + 1, name.length());
        }
        return name;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public Directory getAsDirectory() {
        return this;
    }

    @Override
    public StoredObject getAsObject() {
        throw new UnsupportedOperationException("A Directory cannot be cast to a StoredObject");
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public void metadataSetFromHeaders() {
    }

    @Override
    public String getBareName() {
        return this.bareName;
    }

    public int hashCode() {
        return this.getName() == null ? 31 : this.getName().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof DirectoryOrObject && this.compareTo((DirectoryOrObject)o) == 0;
    }

    @Override
    public int compareTo(DirectoryOrObject o) {
        return this.getName().compareTo(o.getName());
    }
}

