/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.swift;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.headers.object.DeleteAt;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.headers.object.ObjectContentLength;
import org.javaswift.joss.headers.object.ObjectContentType;
import org.javaswift.joss.headers.object.ObjectLastModified;
import org.javaswift.joss.headers.object.ObjectManifest;
import org.javaswift.joss.information.ObjectInformation;
import org.javaswift.joss.instructions.DownloadInstructions;
import org.javaswift.joss.instructions.UploadInstructions;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.Directory;
import org.javaswift.joss.model.DirectoryOrObject;
import org.javaswift.joss.model.ListSubject;
import org.javaswift.joss.model.StoredObject;
import org.javaswift.joss.swift.HeaderStore;
import org.javaswift.joss.swift.SwiftResult;
import org.javaswift.joss.util.LocalTime;

public class SwiftStoredObject
implements ListSubject,
DirectoryOrObject {
    private String name;
    private byte[] content;
    private Etag etag;
    private ObjectContentType contentType;
    private Date lastModified;
    private ObjectManifest objectManifest;
    private HeaderStore headers = new HeaderStore();
    private DeleteAt deleteAt;

    public SwiftStoredObject(String name) {
        this.name = name;
    }

    public long getBytesUsed() {
        return this.content.length;
    }

    public Etag getEtag() {
        return this.etag;
    }

    public ObjectContentType getContentType() {
        return this.contentType;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void metadataSetFromHeaders() {
    }

    public ObjectInformation getInfo() {
        ObjectInformation objectInformation = new ObjectInformation();
        objectInformation.setMetadata(this.headers.getMetadata());
        objectInformation.setContentLength(new ObjectContentLength(Long.toString(this.content.length)));
        objectInformation.setContentType(this.contentType);
        objectInformation.setEtag(this.etag);
        objectInformation.setLastModified(new ObjectLastModified(this.lastModified));
        objectInformation.setDeleteAt(this.deleteAt);
        objectInformation.setManifest(this.objectManifest);
        return objectInformation;
    }

    public SwiftResult<Object> uploadObject(UploadInstructions uploadInstructions) {
        try {
            this.lastModified = LocalTime.currentDate();
            this.content = IOUtils.toByteArray((InputStream)uploadInstructions.getEntity().getContent());
            this.objectManifest = uploadInstructions.getObjectManifest();
            this.etag = new Etag(uploadInstructions.getMd5() != null ? uploadInstructions.getMd5() : DigestUtils.md5Hex((byte[])this.content));
            this.contentType = uploadInstructions.getContentType() != null ? uploadInstructions.getContentType() : new ObjectContentType(new MimetypesFileTypeMap().getContentType(this.getName()));
            return new SwiftResult<Object>(201);
        }
        catch (IOException err) {
            return new SwiftResult<Object>(422);
        }
    }

    public SwiftResult<Object> copyFrom(SwiftStoredObject sourceObject) {
        UploadInstructions uploadInstructions = new UploadInstructions((byte[])sourceObject.getContent().clone());
        uploadInstructions.setContentType(sourceObject.getContentType().getHeaderValue());
        this.uploadObject(uploadInstructions);
        return new SwiftResult<Object>(201);
    }

    public SwiftResult<byte[]> downloadObject(DownloadInstructions downloadInstructions) {
        byte[] object = this.content;
        if (downloadInstructions.getRange() != null) {
            return new SwiftResult<byte[]>(downloadInstructions.getRange().copy(object), 206);
        }
        if (downloadInstructions.getMatchConditional() != null) {
            downloadInstructions.getMatchConditional().matchAgainst(this.etag.getHeaderValue());
        }
        if (downloadInstructions.getSinceConditional() != null) {
            downloadInstructions.getSinceConditional().sinceAgainst(this.lastModified);
        }
        return new SwiftResult<byte[]>(object, 200);
    }

    public SwiftResult<Object> saveMetadata(Collection<? extends Header> headers) {
        this.headers.saveMetadata(headers);
        return new SwiftResult<Object>(202);
    }

    public byte[] getContent() {
        return this.content;
    }

    public ObjectManifest getObjectManifest() {
        return this.objectManifest;
    }

    public void setDeleteAt(DeleteAt deleteAt) {
        this.deleteAt = deleteAt;
    }

    public static Collection<DirectoryOrObject> convertToDirectories(Container container, Collection<SwiftStoredObject> objects, String prefix, Character delimiter) {
        TreeSet<DirectoryOrObject> files = new TreeSet<DirectoryOrObject>();
        for (SwiftStoredObject sourceObject : objects) {
            if (prefix != null && !sourceObject.getName().startsWith(prefix)) continue;
            int searchDirectoryDepth = prefix == null ? 0 : prefix.length() - prefix.replace(delimiter.toString(), "").length();
            StringTokenizer tokenizer = new StringTokenizer(sourceObject.getName(), delimiter.toString());
            StringBuilder path = new StringBuilder();
            int currentDepth = 0;
            while (tokenizer.hasMoreTokens()) {
                if (currentDepth > 0) {
                    path.append(delimiter);
                    if (currentDepth == searchDirectoryDepth + 1) {
                        files.add(new Directory(path.toString(), delimiter));
                    }
                }
                String token = tokenizer.nextToken();
                path.append(token);
                ++currentDepth;
            }
            if (currentDepth != searchDirectoryDepth + 1) continue;
            files.add(sourceObject.copyToStoredObject(container.getObject(sourceObject.getName())));
        }
        return files;
    }

    protected StoredObject copyToStoredObject(StoredObject targetObject) {
        targetObject.setContentLength(this.getBytesUsed());
        targetObject.setContentTypeWithoutSaving(this.getContentType().getHeaderValue());
        targetObject.setEtag(this.getEtag().getHeaderValue());
        targetObject.setLastModified(this.getLastModified());
        targetObject.metadataSetFromHeaders();
        return targetObject;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Directory getAsDirectory() {
        return null;
    }

    @Override
    public StoredObject getAsObject() {
        return null;
    }

    @Override
    public String getBareName() {
        return null;
    }
}

