/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.javaswift.joss.util.FileReference;

public class FileAction {
    public static void handleEntity(File targetFile, HttpEntity entity) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(targetFile);
            IOUtils.copy((InputStream)entity.getContent(), (OutputStream)output);
        }
        catch (Throwable throwable) {
            FileAction.close(output);
            throw throwable;
        }
        FileAction.close(output);
    }

    public static String getMd5(File file) throws IOException {
        String string;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            string = DigestUtils.md5Hex((InputStream)input);
        }
        catch (Throwable throwable) {
            FileAction.close(input);
            throw throwable;
        }
        FileAction.close(input);
        return string;
    }

    protected static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static List<FileReference> listFiles(File root) {
        return FileAction.listFiles(root, new String[0]);
    }

    public static List<FileReference> listFiles(File root, String[] ignoreFilters) {
        ArrayList<FileReference> files = new ArrayList<FileReference>();
        ArrayList<String> path = new ArrayList<String>();
        if (root.isDirectory()) {
            FileAction.listFiles(files, path, root, ignoreFilters);
        }
        return files;
    }

    protected static void listFiles(List<FileReference> files, List<String> path, File directoryFile, String[] ignoreFilters) {
        for (File currentFile : directoryFile.listFiles()) {
            if (FileAction.ignore(path, ignoreFilters)) continue;
            List<String> currentPath = FileAction.getPath(path, currentFile.getName());
            if (currentFile.isDirectory()) {
                FileAction.listFiles(files, currentPath, currentFile, ignoreFilters);
                continue;
            }
            files.add(new FileReference(currentFile, currentPath));
        }
    }

    protected static boolean ignore(List<String> pathAndFile, String[] ignoreFilters) {
        String path = FileReference.getPath(0, pathAndFile);
        for (String ignoreFilter : ignoreFilters) {
            if (!path.equals(ignoreFilter)) continue;
            return true;
        }
        return false;
    }

    protected static List<String> getPath(List<String> currentPath, String extension) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(currentPath);
        path.add(extension);
        return path;
    }

    public static File getFile(Class classPathProvider, String resource) throws IOException, URISyntaxException {
        ClassLoader classLoader = classPathProvider.getClassLoader();
        return new File(classLoader.getResource(resource).getPath());
    }

    public static File getFile(String resource) throws IOException, URISyntaxException {
        ClassLoader classLoader = FileAction.class.getClassLoader();
        Enumeration<URL> urls = classLoader.getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            return new File(url.toURI());
        }
        return null;
    }
}

