/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.Consumer;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.ShadowScope;
import org.javers.shadow.Shadow;
import org.javers.shadow.ShadowFactory;

public class ShadowQueryRunner {
    private final JaversExtendedRepository repository;
    private final ShadowFactory shadowFactory;

    public ShadowQueryRunner(JaversExtendedRepository repository, ShadowFactory shadowFactory) {
        this.repository = repository;
        this.shadowFactory = shadowFactory;
    }

    public List<Shadow> queryForShadows(JqlQuery query, List<CdoSnapshot> coreSnapshots) {
        CommitTable commitTable = new CommitTable(coreSnapshots);
        if (query.getShadowScope() == ShadowScope.COMMIT_DEPTH) {
            commitTable.loadFullCommits();
        }
        return commitTable.rootsForQuery(query).stream().map(r -> this.shadowFactory.createShadow(r.root, r.context, (cm, targetId) -> commitTable.findLatestTo((CommitMetadata)cm, (GlobalId)targetId))).collect(Collectors.toList());
    }

    private static class CommitEntry {
        private final CommitMetadata commitMetadata;
        private final Map<GlobalId, CdoSnapshot> entities = new HashMap<GlobalId, CdoSnapshot>();
        private final Map<ValueObjectId, CdoSnapshot> valueObjects = new HashMap<ValueObjectId, CdoSnapshot>();

        CommitEntry(CommitMetadata commitMetadata) {
            this.commitMetadata = commitMetadata;
        }

        void append(CdoSnapshot snapshot) {
            if (snapshot.getGlobalId() instanceof InstanceId) {
                this.entities.put(snapshot.getGlobalId(), snapshot);
            }
            if (snapshot.getGlobalId() instanceof ValueObjectId) {
                this.valueObjects.put((ValueObjectId)snapshot.getGlobalId(), snapshot);
            }
        }

        CdoSnapshot getAny(GlobalId globalId) {
            if (this.entities.containsKey(globalId)) {
                return this.entities.get(globalId);
            }
            return this.valueObjects.get(globalId);
        }

        Collection<CdoSnapshot> getEntities() {
            return this.entities.values();
        }

        Stream<CdoSnapshot> getAllStream() {
            return Stream.concat(this.valueObjects.values().stream(), this.entities.values().stream());
        }

        Set<GlobalId> getMissingParents() {
            Set<GlobalId> result = this.valueObjects.keySet().stream().map(voId -> voId.getOwnerId()).filter(instanceId -> !this.entities.containsKey(instanceId)).collect(Collectors.toSet());
            result.addAll(this.valueObjects.keySet().stream().flatMap(voId -> voId.getParentValueObjectIds().stream()).filter(voId -> !this.valueObjects.containsKey(voId)).collect(Collectors.toSet()));
            return result;
        }
    }

    class CommitTable {
        private final Map<CommitMetadata, CommitEntry> commitsMap = new HashMap<CommitMetadata, CommitEntry>();
        private final List<CommitEntry> commitsList = new ArrayList<CommitEntry>();
        private final List<CdoSnapshot> coreSnapshots;

        CommitTable(List<CdoSnapshot> coreSnapshots) {
            this.coreSnapshots = coreSnapshots;
            if (coreSnapshots.isEmpty()) {
                return;
            }
            coreSnapshots.forEach(s -> {
                CommitEntry current = this.commitsMap.get(s.getCommitMetadata());
                if (current == null) {
                    current = this.nextCommit((CdoSnapshot)s);
                }
                current.append((CdoSnapshot)s);
            });
        }

        List<ShadowRoot> rootsForQuery(JqlQuery query) {
            this.fillMissingParents();
            return this.commitsList.stream().flatMap(e -> e.getAllStream().filter(s -> query.matches(s.getGlobalId())).map(s -> new ShadowRoot(((CommitEntry)e).commitMetadata, (CdoSnapshot)s))).collect(Collectors.toList());
        }

        void loadFullCommits() {
            QueryParams params = QueryParamsBuilder.withLimit(Integer.MAX_VALUE).commitIds(this.commitsMap.keySet().stream().map(cm -> cm.getId()).collect(Collectors.toSet())).build();
            ShadowQueryRunner.this.repository.getSnapshots(params).stream().forEach(s -> this.commitsMap.get(s.getCommitMetadata()).append((CdoSnapshot)s));
        }

        CdoSnapshot findLatestTo(CommitMetadata rootContext, GlobalId targetId) {
            if (!this.commitsMap.containsKey(rootContext)) {
                return null;
            }
            ArrayList found = new ArrayList();
            this.iterateReverseUntil(ce -> {
                if (ce.getAny(targetId) != null) {
                    found.add(ce.getAny(targetId));
                }
            }, rootContext);
            if (found.size() == 0) {
                return null;
            }
            return (CdoSnapshot)found.get(found.size() - 1);
        }

        void fillMissingParents() {
            HashMap movingLatest = new HashMap();
            this.iterateReverse(commitEntry -> {
                commitEntry.getMissingParents().stream().filter(movingLatest::containsKey).forEach(voId -> commitEntry.append((CdoSnapshot)movingLatest.get(voId)));
                commitEntry.getAllStream().forEach(e -> movingLatest.put(e.getGlobalId(), e));
            });
        }

        CommitEntry nextCommit(CdoSnapshot snapshot) {
            CommitEntry entry = new CommitEntry(snapshot.getCommitMetadata());
            this.commitsMap.put(entry.commitMetadata, entry);
            this.commitsList.add(entry);
            return entry;
        }

        void iterateReverse(Consumer<CommitEntry> consumer) {
            ListIterator<CommitEntry> it = this.commitsList.listIterator(this.commitsList.size());
            while (it.hasPrevious()) {
                consumer.consume(it.previous());
            }
        }

        void iterateReverseUntil(Consumer<CommitEntry> consumer, CommitMetadata bound) {
            ListIterator<CommitEntry> it = this.commitsList.listIterator(this.commitsList.size());
            while (it.hasPrevious()) {
                CommitEntry ce = it.previous();
                consumer.consume(ce);
                if (!ce.commitMetadata.equals(bound)) continue;
                break;
            }
        }
    }

    private static class ShadowRoot {
        final CommitMetadata context;
        final CdoSnapshot root;

        ShadowRoot(CdoSnapshot root) {
            this.context = root.getCommitMetadata();
            this.root = root;
        }

        ShadowRoot(CommitMetadata context, CdoSnapshot root) {
            this.context = context;
            this.root = root;
        }
    }
}

