/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;

class NodeReuser {
    private final Map<Object, ObjectNode> reverseCdoIdMap = new HashMap<Object, ObjectNode>();
    private final Set<ObjectNode> nodes = new HashSet<ObjectNode>();
    private final Queue<ObjectNode> stubs = new LinkedList<ObjectNode>();
    private int reusedNodes;
    private int entities;
    private int valueObjects;

    NodeReuser() {
    }

    boolean isReusable(Cdo cdo) {
        return this.reverseCdoIdMap.containsKey(this.reverseCdoIdMapKey(cdo));
    }

    ObjectNode getForReuse(Cdo cdo) {
        ++this.reusedNodes;
        return this.reverseCdoIdMap.get(this.reverseCdoIdMapKey(cdo));
    }

    Set<ObjectNode> nodes() {
        return this.nodes;
    }

    void saveForReuse(ObjectNode reference) {
        if (reference.getGlobalId() instanceof InstanceId) {
            ++this.entities;
        }
        if (reference.getGlobalId() instanceof ValueObjectId) {
            ++this.valueObjects;
        }
        this.reverseCdoIdMap.put(this.reverseCdoIdMapKey(reference.getCdo()), reference);
        this.nodes.add(reference);
    }

    void enqueueStub(ObjectNode nodeStub) {
        this.stubs.offer(nodeStub);
    }

    ObjectNode pollStub() {
        return this.stubs.poll();
    }

    boolean hasMoreStubs() {
        return !this.stubs.isEmpty();
    }

    int nodesCount() {
        return this.reverseCdoIdMap.size();
    }

    int reusedNodesCount() {
        return this.reusedNodes;
    }

    int entitiesCount() {
        return this.entities;
    }

    int voCount() {
        return this.valueObjects;
    }

    private Object reverseCdoIdMapKey(Cdo cdo) {
        if (cdo.getGlobalId() instanceof InstanceId) {
            return cdo.getGlobalId();
        }
        return new SystemIdentityWrapper(cdo.getWrappedCdo().get());
    }

    private static class SystemIdentityWrapper {
        private final Object cdo;

        SystemIdentityWrapper(Object cdo) {
            this.cdo = cdo;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != SystemIdentityWrapper.class) {
                return false;
            }
            return this.cdo == ((SystemIdentityWrapper)o).cdo;
        }

        public int hashCode() {
            return System.identityHashCode(this.cdo);
        }
    }
}

