/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.LinkedList;
import org.javers.common.collections.Arrays;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;

class GlobalIdPathParser {
    private final TypeMapper typeMapper;

    public GlobalIdPathParser(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    ValueObjectType parseChildValueObject(ManagedType ownerType, String path) {
        return this.parseChildValueObjectFromPathSegments(ownerType, this.pathToSegments(path), path);
    }

    private ValueObjectType parseChildValueObjectFromPathSegments(ManagedType ownerType, LinkedList<String> segments, String path) {
        JaversProperty property = ownerType.getProperty(segments.getFirst());
        ValueObjectType childVoType = this.extractChildValueObject((JaversType)property.getType(), path);
        if (segments.size() == 1 || segments.size() == 2 && property.getType() instanceof EnumerableType) {
            return childVoType;
        }
        segments.removeFirst();
        if (property.getType() instanceof EnumerableType) {
            segments.removeFirst();
        }
        return this.parseChildValueObjectFromPathSegments(childVoType, segments, path);
    }

    private ValueObjectType extractChildValueObject(JaversType voPropertyType, String path) {
        JaversType valueType;
        JaversType contentType;
        if (voPropertyType instanceof ValueObjectType) {
            return (ValueObjectType)voPropertyType;
        }
        if (voPropertyType instanceof ContainerType && (contentType = this.typeMapper.getJaversType(((ContainerType)voPropertyType).getItemType())) instanceof ValueObjectType) {
            return (ValueObjectType)contentType;
        }
        if (voPropertyType instanceof MapType && (valueType = this.typeMapper.getJaversType(((MapType)voPropertyType).getValueType())) instanceof ValueObjectType) {
            return (ValueObjectType)valueType;
        }
        throw new JaversException(JaversExceptionCode.CANT_EXTRACT_CHILD_VALUE_OBJECT, path, voPropertyType);
    }

    private LinkedList<String> pathToSegments(String path) {
        Validate.argumentIsNotNull(path);
        return new LinkedList<Object>(Arrays.asList(path.split("/")));
    }
}

