/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.inmemory;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepository.class);
    private Map<String, LinkedList<String>> snapshots = new ConcurrentHashMap<String, LinkedList<String>>();
    private Map<CommitId, Integer> commits = new ConcurrentHashMap<CommitId, Integer>();
    private AtomicInteger counter = new AtomicInteger();
    private CommitId head;
    private JsonConverter jsonConverter;

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path, queryParams);
        List<CdoSnapshot> result = Lists.positiveFilter(this.getAll(), input -> {
            if (!(input.getGlobalId() instanceof ValueObjectId)) {
                return false;
            }
            ValueObjectId id = (ValueObjectId)input.getGlobalId();
            return id.hasOwnerOfType(ownerEntity) && id.getFragment().equals(path);
        });
        return this.applyQueryParams(result, queryParams);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, queryParams);
        ArrayList<CdoSnapshot> filtered = new ArrayList<CdoSnapshot>();
        for (CdoSnapshot snapshot : this.getAll()) {
            if (snapshot.getGlobalId().equals(globalId)) {
                filtered.add(snapshot);
            }
            if (!queryParams.isAggregate() || !this.isParent(globalId, snapshot.getGlobalId())) continue;
            filtered.add(snapshot);
        }
        return this.applyQueryParams(filtered, queryParams);
    }

    private boolean isParent(GlobalId parentCandidate, GlobalId childCandidate) {
        if (!(parentCandidate instanceof InstanceId) || !(childCandidate instanceof ValueObjectId)) {
            return false;
        }
        InstanceId parent = (InstanceId)parentCandidate;
        ValueObjectId child = (ValueObjectId)childCandidate;
        return child.getOwnerId().equals(parent);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        Validate.argumentsAreNotNull(givenClasses, queryParams);
        ArrayList<CdoSnapshot> filtered = new ArrayList<CdoSnapshot>();
        for (CdoSnapshot snapshot : this.getAll()) {
            for (ManagedType givenClass : givenClasses) {
                if (snapshot.getGlobalId().isTypeOf(givenClass)) {
                    filtered.add(snapshot);
                }
                if (!queryParams.isAggregate() || !this.isParent(givenClass, snapshot.getGlobalId())) continue;
                filtered.add(snapshot);
            }
        }
        return this.applyQueryParams(filtered, queryParams);
    }

    private boolean isParent(ManagedType parentCandidate, GlobalId childCandidate) {
        if (!(parentCandidate instanceof EntityType) || !(childCandidate instanceof ValueObjectId)) {
            return false;
        }
        EntityType parent = (EntityType)parentCandidate;
        ValueObjectId child = (ValueObjectId)childCandidate;
        return child.getOwnerId().getTypeName().equals(parent.getName());
    }

    private List<CdoSnapshot> applyQueryParams(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        if (queryParams.commitIds().size() > 0) {
            snapshots = this.filterSnapshotsByCommitIds(snapshots, queryParams.commitIds());
        }
        if (queryParams.toCommitId().isPresent()) {
            snapshots = this.filterSnapshotsByToCommitId(snapshots, queryParams.toCommitId().get());
        }
        if (queryParams.version().isPresent()) {
            snapshots = Lists.positiveFilter(snapshots, snapshot -> snapshot.getVersion() == queryParams.version().get().longValue());
        }
        if (queryParams.author().isPresent()) {
            snapshots = this.filterSnapshotsByAuthor(snapshots, queryParams.author().get());
        }
        if (this.hasDates(queryParams)) {
            snapshots = this.filterSnapshotsByCommitDate(snapshots, queryParams);
        }
        if (this.hasInstants(queryParams)) {
            snapshots = this.filterSnapshotsByCommitDateInstant(snapshots, queryParams);
        }
        if (queryParams.changedProperties().size() > 0) {
            snapshots = this.filterByPropertyNames(snapshots, queryParams.changedProperties());
        }
        if (queryParams.snapshotType().isPresent()) {
            snapshots = Lists.positiveFilter(snapshots, snapshot -> snapshot.getType() == queryParams.snapshotType().get());
        }
        snapshots = this.filterSnapshotsByCommitProperties(snapshots, queryParams.commitProperties());
        return this.trimResultsToRequestedSlice(snapshots, queryParams.skip(), queryParams.limit());
    }

    private List<CdoSnapshot> filterSnapshotsByToCommitId(List<CdoSnapshot> snapshots, CommitId commitId) {
        return Lists.positiveFilter(snapshots, snapshot -> snapshot.getCommitMetadata().getId().isBeforeOrEqual(commitId));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitIds(List<CdoSnapshot> snapshots, Set<CommitId> commitIds) {
        return Lists.positiveFilter(snapshots, snapshot -> commitIds.contains(snapshot.getCommitId()));
    }

    private List<CdoSnapshot> filterSnapshotsByAuthor(List<CdoSnapshot> snapshots, String author) {
        return Lists.positiveFilter(snapshots, snapshot -> author.equals(snapshot.getCommitMetadata().getAuthor()));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitDate(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        return Lists.positiveFilter(snapshots, snapshot -> this.isDateInRange(queryParams, snapshot.getCommitMetadata().getCommitDate()));
    }

    public boolean isDateInRange(QueryParams q, LocalDateTime date) {
        if (q.from().isPresent() && q.from().get().isAfter(date)) {
            return false;
        }
        return !q.to().isPresent() || !q.to().get().isBefore(date);
    }

    private List<CdoSnapshot> filterSnapshotsByCommitDateInstant(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        return Lists.positiveFilter(snapshots, snapshot -> this.isInstantInRange(queryParams, snapshot.getCommitMetadata().getCommitDateInstant()));
    }

    private boolean isInstantInRange(QueryParams q, Instant instant) {
        if (q.fromInstant().isPresent() && q.fromInstant().get().isAfter(instant)) {
            return false;
        }
        return !q.toInstant().isPresent() || !q.toInstant().get().isBefore(instant);
    }

    private List<CdoSnapshot> filterSnapshotsByCommitProperties(List<CdoSnapshot> snapshots, Map<String, String> commitProperties) {
        return Lists.positiveFilter(snapshots, snapshot -> commitProperties.entrySet().stream().allMatch(commitProperty -> {
            Map<String, String> actualCommitProperties = snapshot.getCommitMetadata().getProperties();
            return actualCommitProperties.containsKey(commitProperty.getKey()) && actualCommitProperties.get(commitProperty.getKey()).equals(commitProperty.getValue());
        }));
    }

    private List<CdoSnapshot> trimResultsToRequestedSlice(List<CdoSnapshot> snapshots, int from, int size) {
        int fromIndex = Math.min(from, snapshots.size());
        int toIndex = Math.min(from + size, snapshots.size());
        return new ArrayList<CdoSnapshot>(snapshots.subList(fromIndex, toIndex));
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentsAreNotNull(globalId);
        if (this.contains(globalId)) {
            return Optional.of(this.readSnapshots(globalId).peek());
        }
        return Optional.empty();
    }

    @Override
    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        Validate.argumentIsNotNull(queryParams);
        return this.applyQueryParams(this.getAll(), queryParams);
    }

    @Override
    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return Lists.transform(this.getPersistedIdentifiers(snapshotIdentifiers), snapshotIdentifier -> {
            LinkedList<CdoSnapshot> objectSnapshots = this.readSnapshots(snapshotIdentifier.getGlobalId());
            return (CdoSnapshot)objectSnapshots.get(objectSnapshots.size() - (int)snapshotIdentifier.getVersion());
        });
    }

    private List<SnapshotIdentifier> getPersistedIdentifiers(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return Lists.positiveFilter(new ArrayList<SnapshotIdentifier>(snapshotIdentifiers), snapshotIdentifier -> this.contains(snapshotIdentifier.getGlobalId()) && snapshotIdentifier.getVersion() <= (long)this.readSnapshots(snapshotIdentifier.getGlobalId()).size());
    }

    @Override
    public void persist(Commit commit) {
        Validate.argumentsAreNotNull(commit);
        List<CdoSnapshot> snapshots = commit.getSnapshots();
        for (CdoSnapshot s : snapshots) {
            this.persist(s);
        }
        logger.debug("{} snapshot(s) persisted", (Object)snapshots.size());
        this.head = commit.getId();
        this.commits.put(this.getHeadId(), this.counter.incrementAndGet());
    }

    @Override
    public CommitId getHeadId() {
        return this.head;
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    private List<CdoSnapshot> filterByPropertyNames(List<CdoSnapshot> snapshots, Set<String> propertyNames) {
        return Lists.positiveFilter(snapshots, input -> propertyNames.stream().anyMatch(input::hasChangeAt));
    }

    private List<CdoSnapshot> getAll() {
        ArrayList<CdoSnapshot> all = new ArrayList<CdoSnapshot>();
        this.snapshots.keySet().forEach(it -> all.addAll(this.readSnapshots((String)it)));
        Collections.sort(all, Comparator.comparingInt(o1 -> Integer.MAX_VALUE - this.getSeq(o1.getCommitMetadata().getId())));
        return all;
    }

    private int getSeq(CommitId commitId) {
        return this.commits.get(commitId);
    }

    private synchronized void persist(CdoSnapshot snapshot) {
        Validate.conditionFulfilled(this.jsonConverter != null, "jsonConverter is null");
        String globalIdValue = snapshot.getGlobalId().value();
        LinkedList<String> snapshotsList = this.snapshots.get(globalIdValue);
        if (snapshotsList == null) {
            snapshotsList = new LinkedList();
            this.snapshots.put(globalIdValue, snapshotsList);
        }
        snapshotsList.push(this.jsonConverter.toJson(snapshot));
    }

    @Override
    public void ensureSchema() {
    }

    private boolean contains(GlobalId globalId) {
        return this.contains(globalId.value());
    }

    private boolean contains(String globalIdValue) {
        return this.snapshots.containsKey(globalIdValue);
    }

    private LinkedList<CdoSnapshot> readSnapshots(String globalIdValue) {
        LinkedList<CdoSnapshot> result = new LinkedList<CdoSnapshot>();
        if (!this.contains(globalIdValue)) {
            return result;
        }
        this.snapshots.get(globalIdValue).forEach(it -> result.add(this.jsonConverter.fromJson((String)it, CdoSnapshot.class)));
        return result;
    }

    private LinkedList<CdoSnapshot> readSnapshots(GlobalId globalId) {
        return this.readSnapshots(globalId.value());
    }

    private boolean hasDates(QueryParams q) {
        return q.from().isPresent() || q.to().isPresent();
    }

    public boolean hasInstants(QueryParams q) {
        return q.fromInstant().isPresent() || q.toInstant().isPresent();
    }
}

