/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Maps;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;

class MapChangeAppender
implements PropertyChangeAppender<MapChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    MapChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        Validate.argumentsAreNotNull(typeMapper, globalIdFactory);
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        if (!(propertyType instanceof MapType)) {
            return false;
        }
        MapContentType mapContentType = this.typeMapper.getMapContentType((MapType)propertyType);
        if (mapContentType.getKeyType() instanceof ValueObjectType) {
            throw new JaversException(JaversExceptionCode.VALUE_OBJECT_IS_NOT_SUPPORTED_AS_MAP_KEY, propertyType);
        }
        return true;
    }

    @Override
    public MapChange calculateChanges(NodePair pair, JaversProperty property) {
        MapType mapType;
        MapContentType mapContentType;
        Map right;
        Map left = (Map)pair.getLeftDehydratedPropertyValueAndSanitize(property);
        List<EntryChange> changes = this.calculateEntryChanges(left, right = (Map)pair.getRightDehydratedPropertyValueAndSanitize(property), mapContentType = this.typeMapper.getMapContentType(mapType = (MapType)property.getType()));
        if (!changes.isEmpty()) {
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(mapContentType.getKeyType().getBaseJavaType(), "key", "Map", property);
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(mapContentType.getValueType().getBaseJavaType(), "value", "Map", property);
            return new MapChange(pair.getGlobalId(), property.getName(), changes);
        }
        return null;
    }

    List<EntryChange> calculateEntryChanges(Map leftMap, Map rightMap, MapContentType mapContentType) {
        ArrayList<EntryChange> changes = new ArrayList<EntryChange>();
        for (Object commonKey : Maps.commonKeys(leftMap, rightMap)) {
            Object leftVal = leftMap.get(commonKey);
            Object rightVal = rightMap.get(commonKey);
            if (mapContentType.getValueType().equals(leftVal, rightVal)) continue;
            changes.add(new EntryValueChange(commonKey, leftVal, rightVal));
        }
        for (Object addedKey : Maps.keysDifference(rightMap, leftMap)) {
            Object addedValue = rightMap.get(addedKey);
            changes.add(new EntryAdded(addedKey, addedValue));
        }
        for (Object removedKey : Maps.keysDifference(leftMap, rightMap)) {
            Object removedValue = leftMap.get(removedKey);
            changes.add(new EntryRemoved(removedKey, removedValue));
        }
        return changes;
    }
}

