/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import org.javers.core.diff.EqualsFunction;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.levenshtein.Backtrack;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.appenders.levenshtein.StepsToChanges;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;

public class LevenshteinListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(Object leftValue, Object rightValue, NodePair pair, JaversProperty property) {
        JaversType itemType = ((ListType)property.getType()).getItemJaversType();
        List leftList = (List)leftValue;
        List rightList = (List)rightValue;
        EqualsFunction equalsFunction = itemType::equals;
        StepsToChanges stepsToChanges = new StepsToChanges(equalsFunction);
        Backtrack backtrack = new Backtrack(equalsFunction);
        BacktrackSteps[][] steps = backtrack.evaluateSteps(leftList, rightList);
        List<ContainerElementChange> changes = stepsToChanges.convert(steps, leftList, rightList);
        ListChange result = this.createListChange(pair, property, changes, leftList, rightList);
        if (result != null) {
            LevenshteinListChangeAppender.renderNotParametrizedWarningIfNeeded(itemType.getBaseJavaType(), "item", "List", property);
        }
        return result;
    }

    private ListChange createListChange(NodePair pair, JaversProperty property, List<ContainerElementChange> changes, List left, List right) {
        ListChange result = changes.isEmpty() ? null : new ListChange(pair.createPropertyChangeMetadata(property), changes, left, right);
        return result;
    }
}

