/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.repository.sql.session.ObjectMapper;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.QueryBuilder;
import org.javers.repository.sql.session.Select;
import org.javers.repository.sql.session.Session;

public class SelectBuilder
extends QueryBuilder<SelectBuilder> {
    private Session session;
    private String rawSql;

    SelectBuilder(Session session, String selectClauseSQL) {
        this.session = session;
        this.rawSql = "SELECT " + selectClauseSQL;
    }

    public SelectBuilder sql(String sql) {
        this.rawSql = sql;
        return this;
    }

    public SelectBuilder from(String fromClauseSQL) {
        this.rawSql = this.rawSql + " FROM " + fromClauseSQL + " WHERE 1 = 1";
        return this;
    }

    public SelectBuilder and(String columnName, String operator, Parameter parameter) {
        this.parameters.add(parameter);
        this.rawSql = this.rawSql + " AND " + columnName + " " + operator + " ?";
        return this;
    }

    public SelectBuilder and(String predicateSQL, Parameter ... params) {
        this.parameters.addAll(Lists.immutableListOf((Object[])params));
        this.rawSql = this.rawSql + " AND " + predicateSQL;
        return this;
    }

    public SelectBuilder and(String columnName, Long value) {
        return this.and(columnName, "=", Parameter.longParam(value));
    }

    public SelectBuilder and(String columnName, String value) {
        return this.and(columnName, "=", Parameter.stringParam(value));
    }

    public SelectBuilder and(String columnName, BigDecimal value) {
        return this.and(columnName, "=", Parameter.bigDecimalParam(value));
    }

    private Select build() {
        return new Select("SELECT " + this.getQueryName(), this.getParameters(), this.rawSql);
    }

    public SelectBuilder limit(int limit, int offset) {
        this.session.getDialect().limit(this, limit, offset);
        return this;
    }

    public SelectBuilder orderByDesc(String columns) {
        this.append("ORDER BY " + columns + " DESC", new Parameter[0]);
        return this;
    }

    public SelectBuilder orderByAsc(String columns) {
        this.append("ORDER BY " + columns + " ASC", new Parameter[0]);
        return this;
    }

    public SelectBuilder wrap(String leftSql, String rightSql, Parameter ... params) {
        this.parameters.addAll(Lists.immutableListOf((Object[])params));
        this.rawSql = leftSql + " " + this.rawSql + " " + rightSql;
        return this;
    }

    public SelectBuilder append(String moreSql, Parameter ... params) {
        return this.wrap("", moreSql, params);
    }

    public long queryForLong(String queryName) {
        this.queryName(queryName);
        return this.session.executeQueryForLong(this.build());
    }

    public Optional<BigDecimal> queryForOptionalBigDecimal(String queryName) {
        this.queryName(queryName);
        return this.session.executeQueryForOptionalBigDecimal(this.build());
    }

    public Optional<Long> queryForOptionalLong() {
        return this.session.executeQueryForOptionalLong(this.build());
    }

    public <T> List<T> executeQuery(ObjectMapper<T> objectMapper) {
        return this.session.executeQuery(this.build(), objectMapper);
    }
}

