/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.repositories;

import java.util.List;
import java.util.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.sql.codecs.CdoSnapshotStateCodec;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.javers.repository.sql.session.Session;

public class CdoSnapshotRepository
extends SchemaNameAware {
    private JsonConverter jsonConverter;
    private final GlobalIdRepository globalIdRepository;
    private final CdoSnapshotStateCodec cdoSnapshotStateCodec;

    public CdoSnapshotRepository(GlobalIdRepository globalIdRepository, TableNameProvider tableNameProvider, CdoSnapshotStateCodec cdoSnapshotStateCodec) {
        super(tableNameProvider);
        this.globalIdRepository = globalIdRepository;
        this.cdoSnapshotStateCodec = cdoSnapshotStateCodec;
    }

    public void save(long commitIdPk, List<CdoSnapshot> cdoSnapshots, Session session) {
        cdoSnapshots.stream().filter(it -> it.isInstance()).forEach(cdoSnapshot -> {
            long globalIdPk = this.globalIdRepository.getOrInsertId(cdoSnapshot.getGlobalId(), Optional.of(cdoSnapshot.isInitial()), session);
            this.insertSnapshot((CdoSnapshot)cdoSnapshot, globalIdPk, commitIdPk, session);
        });
        cdoSnapshots.stream().filter(it -> !it.isInstance()).forEach(cdoSnapshot -> {
            long globalIdPk = this.globalIdRepository.getOrInsertId(cdoSnapshot.getGlobalId(), Optional.of(cdoSnapshot.isInitial()), session);
            this.insertSnapshot((CdoSnapshot)cdoSnapshot, globalIdPk, commitIdPk, session);
        });
    }

    private void insertSnapshot(CdoSnapshot cdoSnapshot, long globalIdPk, long commitIdPk, Session session) {
        session.insert("Snapshot").into(this.getSnapshotTableNameWithSchema()).value("type", cdoSnapshot.getType().toString()).value("global_id_fk", globalIdPk).value("commit_fk", commitIdPk).value("version", cdoSnapshot.getVersion()).value("state", this.cdoSnapshotStateCodec.encode(this.jsonConverter.toJson((Object)cdoSnapshot.getState()))).value("changed_properties", this.jsonConverter.toJson((Object)cdoSnapshot.getChanged())).value("managed_type", cdoSnapshot.getManagedType().getName()).sequence("snapshot_pk", this.getSnapshotTablePkSeqName().nameWithSchema()).execute();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

