/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StoryDuration {
    private long startedAtMillis;
    private long durationInMillis;
    private final long timeoutInSecs;

    public StoryDuration(long timeoutInSecs) {
        this(System.currentTimeMillis(), timeoutInSecs);
    }

    public StoryDuration(long startedAtMillis, long timeoutInSecs) {
        this.startedAtMillis = startedAtMillis;
        this.timeoutInSecs = timeoutInSecs;
    }

    public long getDurationInSecs() {
        return this.durationInMillis / 1000L;
    }

    public long getTimeoutInSecs() {
        return this.timeoutInSecs;
    }

    public StoryDuration setDurationInSecs(long durationInSecs) {
        this.durationInMillis = durationInSecs * 1000L;
        return this;
    }

    public StoryDuration update() {
        this.durationInMillis = this.elapsedTimeInMillis();
        return this;
    }

    private long elapsedTimeInMillis() {
        return System.currentTimeMillis() - this.startedAtMillis;
    }

    public boolean timedOut() {
        return this.timeoutInSecs != 0L && this.getDurationInSecs() > this.timeoutInSecs;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }
}

