/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;

abstract class AbstractRegexParser {
    protected static final String NONE = "";
    private final Keywords keywords;

    protected AbstractRegexParser() {
        this(new LocalizedKeywords());
    }

    protected AbstractRegexParser(Keywords keywords) {
        this.keywords = keywords;
    }

    protected Keywords keywords() {
        return this.keywords;
    }

    protected static List<String> splitElements(String text, String keyword) {
        ArrayList<String> elements = new ArrayList<String>();
        for (String elementAsText : text.split(keyword)) {
            if (elementAsText.trim().length() <= 0) continue;
            elements.add(keyword + "\n" + elementAsText);
        }
        return elements;
    }

    protected String startingWithNL(String text) {
        if (!text.startsWith("\n")) {
            return "\n" + text;
        }
        return text;
    }

    protected List<String> findSteps(String stepsAsText) {
        Matcher matcher = this.findingSteps().matcher(stepsAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(StringUtils.substringAfter((String)matcher.group(1), (String)"\n"));
            startAt = matcher.start(4);
        }
        return steps;
    }

    private Pattern findingSteps() {
        String initialStartingWords = this.concatenateInitialStartingWords();
        String followingStartingWords = this.concatenateFollowingStartingWords();
        return Pattern.compile("((" + initialStartingWords + ")\\s(.)*?)\\s*(\\Z|" + followingStartingWords + "|\\n" + this.keywords().examplesTable() + ")", 32);
    }

    protected String concatenateInitialStartingWords() {
        return this.concatenateStartingWords(NONE);
    }

    protected String concatenateFollowingStartingWords() {
        return this.concatenateStartingWords("\\s");
    }

    private String concatenateStartingWords(String afterKeyword) {
        return this.concatenateWithOr("\\n", afterKeyword, this.keywords().startingWords());
    }

    protected String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr((String)null, (String)null, keywords);
    }

    private String concatenateWithOr(String beforeKeyword, String afterKeyword, String[] keywords) {
        String before = beforeKeyword != null ? beforeKeyword : NONE;
        String after = afterKeyword != null ? afterKeyword : NONE;
        StringBuilder builder = new StringBuilder(before).append("(?:");
        for (String keyword : keywords) {
            builder.append(keyword).append('|');
        }
        if (keywords.length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(')').append(after).toString();
    }
}

