/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.Composite;
import org.jbehave.core.parsers.AbstractRegexParser;
import org.jbehave.core.parsers.CompositeParser;
import org.jbehave.core.steps.StepType;

public class RegexCompositeParser
extends AbstractRegexParser
implements CompositeParser {
    public RegexCompositeParser() {
    }

    public RegexCompositeParser(Keywords keywords) {
        super(keywords);
    }

    @Override
    public List<Composite> parseComposites(String compositesAsText) {
        ArrayList<Composite> parsed = new ArrayList<Composite>();
        for (String compositeAsText : RegexCompositeParser.splitElements(compositesAsText, this.keywords().composite())) {
            parsed.add(this.parseComposite(compositeAsText));
        }
        return parsed;
    }

    private Composite parseComposite(String compositeAsText) {
        String compositePattern = this.findCompositePattern(compositeAsText);
        String compositeWithoutKeyword = StringUtils.removeStart((String)compositeAsText, (String)this.keywords().composite()).trim();
        String compositeWithoutName = StringUtils.removeStart((String)compositeWithoutKeyword, (String)compositePattern);
        compositeWithoutName = this.startingWithNL(compositeWithoutName);
        List<String> steps = this.findSteps(compositeWithoutName);
        StepType stepType = this.keywords().stepTypeFor(compositePattern);
        String stepWithoutStartingWord = this.keywords().stepWithoutStartingWord(compositePattern, stepType);
        return new Composite(stepType, stepWithoutStartingWord, steps);
    }

    private String findCompositePattern(String compositeAsText) {
        Matcher findingPattern = this.findingCompositePattern().matcher(compositeAsText);
        return findingPattern.find() ? findingPattern.group(1).trim() : "";
    }

    private Pattern findingCompositePattern() {
        String startingWords = this.concatenateInitialStartingWords();
        return Pattern.compile(this.keywords().composite() + "((.)*?)\\s*(" + startingWords + ").*", 32);
    }
}

