/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.PrintStream;
import java.util.List;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.steps.Stepdoc;

public class PrintStreamStepdocReporter
implements StepdocReporter {
    private static final String STEP_MATCHED_BY = "Step '%s' is matched by annotated patterns:";
    private static final String STEP_NOT_MATCHED = "Step '%s' is not matched by any pattern";
    private static final String STEPDOC = "'%s %s'";
    private PrintStream output;

    public PrintStreamStepdocReporter() {
        this(System.out);
    }

    public PrintStreamStepdocReporter(PrintStream output) {
        this.output = output;
    }

    @Override
    public void stepdocsMatching(String stepAsString, List<Stepdoc> stepdocs, List<Object> stepsInstances) {
        if (stepdocs.size() > 0) {
            this.output(STEP_MATCHED_BY, stepAsString);
            this.outputStepdocs(stepdocs);
        } else {
            this.output(STEP_NOT_MATCHED, stepAsString);
        }
        this.outputStepsInstances(stepsInstances);
    }

    @Override
    public void stepdocs(List<Stepdoc> stepdocs, List<Object> stepsInstances) {
        this.outputStepdocs(stepdocs);
        this.outputStepsInstances(stepsInstances);
    }

    private void outputStepdocs(List<Stepdoc> stepdocs) {
        for (Stepdoc stepdoc : stepdocs) {
            this.output(STEPDOC, stepdoc.getStartingWord(), stepdoc.getPattern());
            this.output(stepdoc.getMethodSignature(), new Object[0]);
        }
    }

    private void outputStepsInstances(List<Object> stepsInstances) {
        if (stepsInstances.size() > 0) {
            this.output("from steps instances:", new Object[0]);
            for (Object stepsInstance : stepsInstances) {
                this.output(stepsInstance.getClass().getName(), new Object[0]);
            }
        } else {
            this.output("as no steps instances are provided", new Object[0]);
        }
    }

    private void output(String format, Object ... args) {
        Format.println(this.output, format, args);
    }
}

