/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;

public class InstanceStepsFactory
extends AbstractStepsFactory {
    private final Map<Class<?>, Object> stepsInstances = new LinkedHashMap();

    public InstanceStepsFactory(Configuration configuration, Object ... stepsInstances) {
        this(configuration, Arrays.asList(stepsInstances));
    }

    public InstanceStepsFactory(Configuration configuration, List<?> stepsInstances) {
        super(configuration);
        for (Object instance : stepsInstances) {
            this.stepsInstances.put(instance.getClass(), instance);
        }
    }

    @Override
    protected List<Class<?>> stepsTypes() {
        return new ArrayList(this.stepsInstances.keySet());
    }

    @Override
    public Object createInstanceOfType(Class<?> type) {
        Object instance = this.stepsInstances.get(type);
        if (instance == null) {
            throw new AbstractStepsFactory.StepsInstanceNotFound(type, this);
        }
        return instance;
    }
}

