/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.JarFileScanner;

public class StoryFinder {
    private static final String JAR = ".jar";
    private static final String JAVA = ".java";
    private final String classNameExtension;
    private final Comparator<? super String> sortingComparator;

    public StoryFinder() {
        this(JAVA);
    }

    public StoryFinder(String classNameExtension) {
        this(classNameExtension, null);
    }

    @Deprecated
    public StoryFinder(Comparator<? super String> sortingComparator) {
        this(JAVA, sortingComparator);
    }

    @Deprecated
    private StoryFinder(String classNameExtension, Comparator<? super String> sortingComparator) {
        this.classNameExtension = classNameExtension;
        this.sortingComparator = sortingComparator;
    }

    public List<String> findClassNames(String searchIn, List<String> includes, List<String> excludes) {
        return this.classNames(this.normalise(this.sort(this.scan(searchIn, includes, excludes))));
    }

    public List<String> findPaths(URL searchIn, String include, String exclude) {
        return this.findPaths(CodeLocations.getPathFromURL(searchIn), this.asCSVList(include), this.asCSVList(exclude));
    }

    public List<String> findPaths(URL searchIn, String[] includes, String[] excludes) {
        return this.findPaths(CodeLocations.getPathFromURL(searchIn), Arrays.asList(includes), Arrays.asList(excludes));
    }

    public List<String> findPaths(String searchIn, String include, String exclude) {
        return this.findPaths(searchIn, this.asCSVList(include), this.asCSVList(exclude));
    }

    public List<String> findPaths(String searchIn, String[] includes, String[] excludes) {
        return this.findPaths(searchIn, Arrays.asList(includes), Arrays.asList(excludes));
    }

    public List<String> findPaths(URL searchIn, List<String> includes, List<String> excludes) {
        return this.findPaths(CodeLocations.getPathFromURL(searchIn), includes, excludes);
    }

    public List<String> findPaths(String searchIn, List<String> includes, List<String> excludes) {
        return this.normalise(this.sort(this.scan(searchIn, includes, excludes)));
    }

    public List<String> findPaths(String searchIn, List<String> includes, List<String> excludes, String prefixWith) {
        return this.normalise(this.prefix(prefixWith, this.sort(this.scan(searchIn, includes, excludes))));
    }

    protected List<String> normalise(List<String> paths) {
        return paths.stream().map(path -> path.replace('\\', '/')).collect(Collectors.toList());
    }

    protected List<String> prefix(String prefixWith, List<String> paths) {
        if (StringUtils.isBlank((CharSequence)prefixWith)) {
            return paths;
        }
        return paths.stream().map(prefixWith::concat).collect(Collectors.toList());
    }

    protected List<String> classNames(List<String> paths) {
        return paths.stream().map(path -> {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)this.classNameExtension())) {
                return path;
            }
            return StringUtils.removeEndIgnoreCase((String)path, (String)this.classNameExtension()).replace('/', '.');
        }).collect(Collectors.toList());
    }

    protected String classNameExtension() {
        return this.classNameExtension;
    }

    protected List<String> sort(List<String> input) {
        ArrayList<String> sorted = new ArrayList<String>(input);
        Collections.sort(sorted, this.sortingComparator());
        return sorted;
    }

    protected Comparator<? super String> sortingComparator() {
        return this.sortingComparator;
    }

    protected List<String> scan(String source, List<String> includes, List<String> excludes) {
        if (source.endsWith(JAR)) {
            return this.scanJar(source, includes, excludes);
        }
        return this.scanDirectory(source, includes, excludes);
    }

    private List<String> asCSVList(String pattern) {
        List<String> list = pattern == null ? Arrays.asList(new String[0]) : Arrays.asList(pattern.split(","));
        return list;
    }

    private List<String> scanDirectory(String basedir, List<String> includes, List<String> excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        if (!new File(basedir).exists()) {
            return new ArrayList<String>();
        }
        scanner.setBasedir(basedir);
        if (includes != null) {
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (excludes != null) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }

    protected List<String> scanJar(String jarPath, List<String> includes, List<String> excludes) {
        return new JarFileScanner(jarPath, includes, excludes).scan();
    }
}

