/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;

public class Story {
    private final String path;
    private final Description description;
    private final Narrative narrative;
    private final Meta meta;
    private final GivenStories givenStories;
    private final Lifecycle lifecycle;
    private final List<Scenario> scenarios;
    private String name;

    public Story() {
        this(Arrays.asList(new Scenario[0]));
    }

    public Story(String path) {
        this(path, null, null, Arrays.asList(new Scenario[0]));
    }

    public Story(String path, List<Scenario> scenarios) {
        this(path, null, null, null, scenarios);
    }

    public Story(List<Scenario> scenarios) {
        this(null, null, scenarios);
    }

    public Story(Description description, Narrative narrative, List<Scenario> scenarios) {
        this(null, description, narrative, scenarios);
    }

    public Story(String path, Description description, Narrative narrative, List<Scenario> scenarios) {
        this(path, description, null, narrative, scenarios);
    }

    public Story(String path, Description description, Meta meta, Narrative narrative, List<Scenario> scenarios) {
        this(path, description, meta, narrative, null, scenarios);
    }

    public Story(String path, Description description, Meta meta, Narrative narrative, GivenStories givenStories, List<Scenario> scenarios) {
        this(path, description, meta, narrative, givenStories, null, scenarios);
    }

    public Story(String path, Description description, Meta meta, Narrative narrative, GivenStories givenStories, Lifecycle lifecycle, List<Scenario> scenarios) {
        this.path = path;
        this.description = description;
        this.narrative = narrative;
        this.meta = meta;
        this.givenStories = givenStories;
        this.lifecycle = lifecycle;
        this.scenarios = scenarios;
    }

    public String getPath() {
        if (this.path == null) {
            return "";
        }
        return this.path;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public Description getDescription() {
        if (!this.hasDescription()) {
            return Description.EMPTY;
        }
        return this.description;
    }

    public boolean hasNarrative() {
        return this.narrative != null;
    }

    public Narrative getNarrative() {
        if (!this.hasNarrative()) {
            return Narrative.EMPTY;
        }
        return this.narrative;
    }

    public boolean hasMeta() {
        return this.meta != null;
    }

    public Meta getMeta() {
        if (!this.hasMeta()) {
            return Meta.EMPTY;
        }
        return this.meta;
    }

    public Meta asMeta(String prefix) {
        Properties p = new Properties();
        p.setProperty(prefix + "path", this.getPath());
        p.setProperty(prefix + "description", this.getDescription().asString());
        p.setProperty(prefix + "narrative", this.getNarrative().toString());
        return new Meta(p);
    }

    public boolean hasGivenStories() {
        return this.givenStories != null;
    }

    public GivenStories getGivenStories() {
        if (!this.hasGivenStories()) {
            return GivenStories.EMPTY;
        }
        return this.givenStories;
    }

    public boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    public Lifecycle getLifecycle() {
        if (!this.hasLifecycle()) {
            return Lifecycle.EMPTY;
        }
        return this.lifecycle;
    }

    public List<Scenario> getScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public String getName() {
        return this.name != null ? this.name : this.getPath();
    }

    public void namedAs(String name) {
        this.name = name;
    }

    public Story cloneWithScenarios(List<Scenario> scenarios) {
        Story story = new Story(this.path, this.description, this.meta, this.narrative, this.givenStories, this.lifecycle, scenarios);
        story.namedAs(this.name);
        return story;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

