/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import org.jbehave.core.failures.StepFailed;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.StoryReporter;

public class StepFailureDecorator
extends DelegatingStoryReporter {
    private UUIDExceptionWrapper failure;

    public StepFailureDecorator(StoryReporter delegate) {
        super(delegate);
    }

    @Override
    public void afterStory(boolean givenStory) {
        super.afterStory(givenStory);
        if (this.failure != null) {
            throw this.failure;
        }
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.failure = null;
        super.beforeStory(story, givenStory);
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.failure = (UUIDExceptionWrapper)cause;
        super.failed(step, this.failure);
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.failure = new StepFailed(step, table);
        super.failedOutcomes(step, table);
    }
}

