/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryMap;
import org.jbehave.core.model.StoryMaps;

public class StoryMapper {
    private Map<String, Set<Story>> map = new HashMap<String, Set<Story>>();

    public void map(Story story, MetaFilter metaFilter) {
        Meta storyMeta = story.getMeta();
        if (!metaFilter.excluded(storyMeta)) {
            boolean allScenariosExcluded = story.getScenarios().stream().map(scenario -> scenario.getMeta().inheritFrom(storyMeta)).allMatch(metaFilter::excluded);
            if (!allScenariosExcluded) {
                this.add(metaFilter.asString(), story);
            }
        }
    }

    public StoryMap getStoryMap(String filter) {
        return new StoryMap(filter, this.storiesFor(filter));
    }

    public StoryMaps getStoryMaps() {
        ArrayList<StoryMap> maps = new ArrayList<StoryMap>();
        for (String filter : this.map.keySet()) {
            maps.add(this.getStoryMap(filter));
        }
        return new StoryMaps(maps);
    }

    private void add(String filter, Story story) {
        this.storiesFor(filter).add(story);
    }

    private Set<Story> storiesFor(String filter) {
        Set<Story> stories = this.map.get(filter);
        if (stories == null) {
            stories = new HashSet<Story>();
            this.map.put(filter, stories);
        }
        return stories;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

