/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.expressions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.expressions.ExpressionProcessor;
import org.jbehave.core.expressions.ExpressionResolverMonitor;

public class ExpressionResolver {
    private static final Pattern GREEDY_EXPRESSION_PATTERN = Pattern.compile("#\\{((?:(?!#\\{|\\$\\{).)*)}", 32);
    private static final Pattern RELUCTANT_EXPRESSION_PATTERN = Pattern.compile("#\\{((?:(?![#{])[^)](?![()]))*?|(?:(?!#\\{|\\$\\{).)*?\\)|(?:(?!#\\{|\\$\\{).)*?)}", 32);
    private static final List<Pattern> PATTERNS = Arrays.asList(RELUCTANT_EXPRESSION_PATTERN, GREEDY_EXPRESSION_PATTERN);
    private static final String REPLACEMENT_PATTERN = "\\#\\{%s\\}";
    private final Set<ExpressionProcessor<?>> expressionProcessors;
    private final ExpressionResolverMonitor expressionResolverMonitor;

    public ExpressionResolver(Set<ExpressionProcessor<?>> expressionProcessors, ExpressionResolverMonitor expressionResolverMonitor) {
        this.expressionProcessors = expressionProcessors;
        this.expressionResolverMonitor = expressionResolverMonitor;
    }

    public Object resolveExpressions(boolean dryRun, String stringWithExpressions) {
        if (dryRun) {
            return stringWithExpressions;
        }
        try {
            return this.resolveExpressions(stringWithExpressions, PATTERNS.iterator());
        }
        catch (RuntimeException e) {
            this.expressionResolverMonitor.onExpressionProcessingError(stringWithExpressions, e);
            throw e;
        }
    }

    private Object resolveExpressions(String value, Iterator<Pattern> expressionPatterns) {
        String processedValue = value;
        Matcher expressionMatcher = expressionPatterns.next().matcher(processedValue);
        boolean expressionFound = false;
        while (expressionMatcher.find()) {
            expressionFound = true;
            String expression = expressionMatcher.group(1);
            Object expressionResult = this.apply(expression);
            if (!(expressionResult instanceof String) && ("#{" + expression + "}").equals(processedValue)) {
                return expressionResult;
            }
            if (expressionResult.equals(expression)) continue;
            String regex = String.format(REPLACEMENT_PATTERN, Pattern.quote(expression));
            processedValue = processedValue.replaceFirst(regex, Matcher.quoteReplacement(String.valueOf(expressionResult)));
            expressionFound = false;
            expressionMatcher.reset(processedValue);
        }
        if (expressionFound && expressionPatterns.hasNext()) {
            return this.resolveExpressions(processedValue, expressionPatterns);
        }
        return processedValue;
    }

    private Object apply(String expression) {
        for (ExpressionProcessor<?> processor : this.expressionProcessors) {
            Optional<?> optional = processor.execute(expression);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return expression;
    }
}

