/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.model.ExamplesTableStringBuilder;
import org.jbehave.core.model.ImmutableExamplesTable;
import org.jbehave.core.model.NullTableTransformerMonitor;
import org.jbehave.core.model.TableParsers;
import org.jbehave.core.model.TableTransformerMonitor;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.ChainedRow;
import org.jbehave.core.steps.ConvertedParameters;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.Row;

public class ExamplesTable {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String EMPTY_VALUE = "";
    public static final Pattern INLINED_PROPERTIES_PATTERN = Pattern.compile("\\{(.*?[^\\\\])\\}\\s*(.*)", 32);
    public static final ExamplesTable EMPTY = new ImmutableExamplesTable("");
    private final ParameterConverters parameterConverters;
    private final Row defaults;
    private final TableRows tableRows;
    private final Deque<TableProperties> tablePropertiesQueue = new LinkedList<TableProperties>();
    private Map<String, String> namedParameters = Collections.emptyMap();
    private ParameterControls parameterControls;
    private TableTransformerMonitor tableTransformerMonitor;

    public ExamplesTable(String tableAsString) {
        this(tableAsString, new TableTransformers());
    }

    private ExamplesTable(String tableAsString, TableTransformers tableTransformers) {
        this(tableAsString, new ParameterConverters(new LoadFromClasspath(), tableTransformers), tableTransformers);
    }

    private ExamplesTable(String tableAsString, ParameterConverters parameterConverters, TableTransformers tableTransformers) {
        this(tableAsString, parameterConverters, new TableParsers(new LocalizedKeywords(), parameterConverters), tableTransformers);
    }

    private ExamplesTable(String tableAsString, ParameterConverters parameterConverters, TableParsers tableParsers, TableTransformers tableTransformers) {
        this(tableParsers.parseProperties(tableAsString), parameterConverters, new ParameterControls(), tableParsers, tableTransformers, new NullTableTransformerMonitor());
    }

    ExamplesTable(TablePropertiesQueue tablePropertiesQueue, ParameterConverters parameterConverters, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers, TableTransformerMonitor tableTransformerMonitor) {
        this.parameterConverters = parameterConverters;
        this.parameterControls = parameterControls;
        this.defaults = new ConvertedParameters(EMPTY_MAP, parameterConverters);
        this.tablePropertiesQueue.addAll(tablePropertiesQueue.getProperties());
        this.tableTransformerMonitor = tableTransformerMonitor;
        String transformedTable = this.applyTransformers(tableTransformers, tablePropertiesQueue.getTable(), tableParsers);
        this.tableRows = tableParsers.parseRows(transformedTable, this.lastTableProperties());
    }

    private TableProperties lastTableProperties() {
        return this.tablePropertiesQueue.getLast();
    }

    private ExamplesTable(ExamplesTable other, Row defaults) {
        this.tableRows = new TableRows(other.tableRows.getHeaders(), other.tableRows.getRows());
        this.parameterConverters = other.parameterConverters;
        this.tablePropertiesQueue.addAll(other.tablePropertiesQueue);
        this.defaults = defaults;
    }

    private String applyTransformers(TableTransformers tableTransformers, String tableAsString, TableParsers tableParsers) {
        String transformedTable = tableAsString;
        TableProperties previousProperties = null;
        for (TableProperties properties : this.tablePropertiesQueue) {
            String transformer = properties.getTransformer();
            if (transformer != null) {
                if (previousProperties != null) {
                    properties.overrideSeparatorsFrom(previousProperties);
                }
                this.tableTransformerMonitor.beforeTransformerApplying(transformer, properties, tableAsString);
                transformedTable = tableTransformers.transform(transformer, transformedTable, tableParsers, properties);
                this.tableTransformerMonitor.afterTransformerApplying(transformer, properties, transformedTable);
            }
            previousProperties = properties;
        }
        return transformedTable;
    }

    public ExamplesTable withDefaults(Parameters defaults) {
        return new ExamplesTable(this, new ChainedRow(defaults, this.defaults));
    }

    public ExamplesTable withNamedParameters(Map<String, String> namedParameters) {
        this.namedParameters = namedParameters;
        return this;
    }

    public ExamplesTable withRowValues(int rowIndex, Map<String, String> values) {
        for (String header : values.keySet()) {
            if (this.getHeaders().contains(header)) continue;
            this.getHeaders().add(header);
        }
        List<String> row = this.getRowValues(rowIndex);
        List<String> headers = this.getHeaders();
        int headersSize = headers.size();
        for (int i = 0; i < headersSize; ++i) {
            String value = values.get(headers.get(i));
            if (i >= row.size()) {
                row.add(Optional.ofNullable(value).orElse(EMPTY_VALUE));
                continue;
            }
            if (value == null) continue;
            row.set(i, value);
        }
        return this;
    }

    public ExamplesTable withRows(List<Map<String, String>> rows) {
        this.tableRows.clear();
        if (!rows.isEmpty()) {
            this.getHeaders().addAll(rows.get(0).keySet());
            rows.stream().map(Map::values).map(ArrayList::new).forEach(this.tableRows.rows::add);
        }
        return this;
    }

    public Properties getProperties() {
        return this.lastTableProperties().getProperties();
    }

    public String getPropertiesAsString() {
        return this.lastTableProperties().getPropertiesAsString();
    }

    private String replaceNamedParameters(String text) {
        return this.parameterControls.replaceAllDelimitedNames(text, this.namedParameters);
    }

    private List<String> replaceNamedParameters(List<String> values, boolean replaceNamedParameters) {
        return replaceNamedParameters ? values.stream().map(this::replaceNamedParameters).collect(Collectors.toList()) : values;
    }

    public List<String> getHeaders() {
        return this.tableRows.getHeaders();
    }

    public Map<String, String> getRow(int rowIndex) {
        return this.getRow(rowIndex, false);
    }

    public Map<String, String> getRow(int rowIndex, boolean replaceNamedParameters) {
        List<String> values = this.getRowValues(rowIndex, replaceNamedParameters);
        if (!this.tableRows.areAllColumnsDistinct()) {
            String exceptionMessage = "ExamplesTable contains non-distinct columns, all columns are: " + String.join((CharSequence)", ", this.getHeaders());
            throw new NonDistinctColumnFound(exceptionMessage);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<String> headers = this.getHeaders();
        int headersSize = headers.size();
        for (int i = 0; i < headersSize; ++i) {
            result.put(headers.get(i), i < values.size() ? values.get(i) : EMPTY_VALUE);
        }
        return result;
    }

    public List<String> getRowValues(int rowIndex) {
        return this.getRowValues(rowIndex, false);
    }

    public List<String> getRowValues(int rowIndex, boolean replaceNamedParameters) {
        return this.replaceNamedParameters(this.tableRows.getRow(rowIndex), replaceNamedParameters);
    }

    public Parameters getRowAsParameters(int rowIndex) {
        return this.getRowAsParameters(rowIndex, false);
    }

    public Parameters getRowAsParameters(int rowIndex, boolean replaceNamedParameters) {
        Map<String, String> row = this.getRow(rowIndex, replaceNamedParameters);
        return new ConvertedParameters(new ChainedRow(new ConvertedParameters(row, this.parameterConverters), this.defaults), this.parameterConverters);
    }

    public int getRowCount() {
        return this.tableRows.getRows().size();
    }

    public boolean metaByRow() {
        return this.lastTableProperties().isMetaByRow();
    }

    public List<Map<String, String>> getRows() {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRow(row));
        }
        return rows;
    }

    public List<Parameters> getRowsAsParameters() {
        return this.getRowsAsParameters(false);
    }

    public List<Parameters> getRowsAsParameters(boolean replaceNamedParameters) {
        ArrayList<Parameters> rows = new ArrayList<Parameters>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRowAsParameters(row, replaceNamedParameters));
        }
        return rows;
    }

    public <T> List<T> getRowsAs(Class<T> type) {
        return this.getRowsAs(type, Collections.emptyMap());
    }

    public <T> List<T> getRowsAs(Class<T> type, Map<String, String> fieldNameMapping) {
        return this.getRowsAsParameters().stream().map(p -> p.mapTo(type, fieldNameMapping)).collect(Collectors.toList());
    }

    public List<String> getColumn(String columnName) {
        return this.getColumn(columnName, false);
    }

    public List<String> getColumn(String columnName, boolean replaceNamedParameters) {
        return this.replaceNamedParameters(this.tableRows.getColumn(columnName), replaceNamedParameters);
    }

    public String getHeaderSeparator() {
        return this.lastTableProperties().getHeaderSeparator();
    }

    public String getValueSeparator() {
        return this.lastTableProperties().getValueSeparator();
    }

    public String asString() {
        if (this.tableRows.getRows().isEmpty()) {
            return EMPTY_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        for (TableProperties properties : this.tablePropertiesQueue) {
            String propertiesAsString = properties.getPropertiesAsString();
            if (propertiesAsString.isEmpty()) continue;
            sb.append("{").append(propertiesAsString).append("}").append(this.lastTableProperties().getRowSeparator());
        }
        sb.append(ExamplesTableStringBuilder.buildExamplesTableString(this.lastTableProperties(), this.getHeaders(), this.tableRows.getRows()));
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.getHeaders().isEmpty();
    }

    public void outputTo(PrintStream output) {
        output.print(this.asString());
    }

    public static ExamplesTable empty() {
        return new ExamplesTable(EMPTY_VALUE);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static final class TablePropertiesQueue {
        private final String table;
        private final Deque<TableProperties> properties;

        TablePropertiesQueue(String table, Deque<TableProperties> properties) {
            this.table = table;
            this.properties = properties;
        }

        String getTable() {
            return this.table;
        }

        Deque<TableProperties> getProperties() {
            return this.properties;
        }
    }

    public static final class TableProperties {
        private static final String COMMA = ",";
        private static final String COMMA_REGEX = "\\,";
        private static final String EQUAL = "=";
        private static final String PIPE_REGEX = "\\|";
        private static final String DECORATORS_REGEX = Stream.of(Decorator.values()).map(Enum::name).collect(Collectors.joining("|", "(", ")"));
        private static final Pattern DECORATED_PROPERTY_PATTERN = Pattern.compile("\\s*\\{([^=,\\s]+(\\|" + DECORATORS_REGEX + ")*)}\\s*", 2);
        private static final String HEADER_SEPARATOR_KEY = "headerSeparator";
        private static final String VALUE_SEPARATOR_KEY = "valueSeparator";
        private static final String IGNORABLE_SEPARATOR_KEY = "ignorableSeparator";
        private static final String COMMENT_SEPARATOR_KEY = "commentSeparator";
        private static final String NULL_PLACEHOLDER_KEY = "nullPlaceholder";
        private static final String PROCESS_ESCAPE_SEQUENCES_KEY = "processEscapeSequences";
        private static final String ROW_SEPARATOR = "\n";
        private final Properties properties = new Properties();
        private final ParameterConverters parameterConverters;
        private final String propertiesAsString;

        public TableProperties(String propertiesAsString, Keywords keywords, ParameterConverters parameterConverters) {
            this.propertiesAsString = propertiesAsString;
            this.parameterConverters = parameterConverters;
            this.properties.setProperty(HEADER_SEPARATOR_KEY, keywords.examplesTableHeaderSeparator());
            this.properties.setProperty(VALUE_SEPARATOR_KEY, keywords.examplesTableValueSeparator());
            this.properties.setProperty(IGNORABLE_SEPARATOR_KEY, keywords.examplesTableIgnorableSeparator());
            this.properties.putAll(this.parseProperties(propertiesAsString));
        }

        private Map<String, String> parseProperties(String propertiesAsString) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            if (!StringUtils.isEmpty((CharSequence)propertiesAsString)) {
                for (String propertyAsString : propertiesAsString.split("(?<!\\\\),")) {
                    String[] property = StringUtils.split((String)propertyAsString, (String)EQUAL, (int)2);
                    String propertyName = property[0];
                    String propertyValue = property[1];
                    Matcher decoratedPropertyMatcher = DECORATED_PROPERTY_PATTERN.matcher(propertyName);
                    if (decoratedPropertyMatcher.matches()) {
                        String[] propertyWithDecorators = decoratedPropertyMatcher.group(1).split(PIPE_REGEX);
                        propertyName = propertyWithDecorators[0];
                        for (int i = 1; i < propertyWithDecorators.length; ++i) {
                            String decorator = propertyWithDecorators[i].toUpperCase();
                            propertyValue = this.decoratePropertyValue(propertyValue, Decorator.valueOf(decorator));
                        }
                    } else {
                        propertyValue = propertyValue.trim();
                    }
                    result.put(propertyName.trim(), StringUtils.replace((String)propertyValue, (String)COMMA_REGEX, (String)COMMA));
                }
            }
            return result;
        }

        private String decoratePropertyValue(String value, Decorator decorator) {
            switch (decorator) {
                case VERBATIM: {
                    return value;
                }
                case LOWERCASE: {
                    return value.toLowerCase();
                }
                case UPPERCASE: {
                    return value.toUpperCase();
                }
            }
            return value.trim();
        }

        public <T> T getMandatoryNonBlankProperty(String propertyName, Type type) {
            String propertyValue = this.properties.getProperty(propertyName);
            Validate.isTrue((propertyValue != null ? 1 : 0) != 0, (String)"'%s' is not set in ExamplesTable properties", (Object[])new Object[]{propertyName});
            Validate.notBlank((CharSequence)propertyValue, (String)"ExamplesTable property '%s' is blank", (Object[])new Object[]{propertyName});
            return (T)this.parameterConverters.convert(propertyValue, type);
        }

        public String getRowSeparator() {
            return ROW_SEPARATOR;
        }

        public String getHeaderSeparator() {
            return this.properties.getProperty(HEADER_SEPARATOR_KEY);
        }

        public String getValueSeparator() {
            return this.properties.getProperty(VALUE_SEPARATOR_KEY);
        }

        public String getIgnorableSeparator() {
            return this.properties.getProperty(IGNORABLE_SEPARATOR_KEY);
        }

        public String getCommentSeparator() {
            return this.properties.getProperty(COMMENT_SEPARATOR_KEY);
        }

        public Optional<String> getNullPlaceholder() {
            return Optional.ofNullable(this.properties.getProperty(NULL_PLACEHOLDER_KEY));
        }

        public boolean isProcessEscapeSequences() {
            String processEscapeSequences = this.properties.getProperty(PROCESS_ESCAPE_SEQUENCES_KEY);
            if (processEscapeSequences != null) {
                String processEscapeSequencesTrimmed = processEscapeSequences.trim().toLowerCase(Locale.ENGLISH);
                if ("true".equals(processEscapeSequencesTrimmed)) {
                    return true;
                }
                if ("false".equals(processEscapeSequencesTrimmed)) {
                    return false;
                }
                throw new IllegalArgumentException("ExamplesTable property 'processEscapeSequences' contains invalid value: '" + processEscapeSequences + "', but allowed values are 'true' and 'false'");
            }
            return false;
        }

        void overrideSeparatorsFrom(TableProperties properties) {
            Stream.of(HEADER_SEPARATOR_KEY, VALUE_SEPARATOR_KEY, IGNORABLE_SEPARATOR_KEY, COMMENT_SEPARATOR_KEY).forEach(key -> {
                String value = properties.properties.getProperty((String)key);
                if (value != null) {
                    this.properties.setProperty((String)key, value);
                }
            });
        }

        public boolean isTrim() {
            return Boolean.parseBoolean(this.properties.getProperty("trim", "true"));
        }

        public boolean isMetaByRow() {
            return Boolean.parseBoolean(this.properties.getProperty("metaByRow", "false"));
        }

        public String getTransformer() {
            return this.properties.getProperty("transformer");
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getPropertiesAsString() {
            return this.propertiesAsString;
        }

        public static enum Decorator {
            LOWERCASE,
            UPPERCASE,
            VERBATIM,
            TRIM;

        }
    }

    public static final class TableRows {
        private final List<String> headers;
        private final List<List<String>> rows;
        private final boolean allColumnsDistinct;

        public TableRows(List<String> headers, List<List<String>> rows) {
            this.headers = headers;
            this.rows = rows;
            this.allColumnsDistinct = headers.stream().distinct().count() == (long)headers.size();
        }

        public List<String> getHeaders() {
            return this.headers;
        }

        public List<List<String>> getRows() {
            return this.rows;
        }

        private boolean areAllColumnsDistinct() {
            return this.allColumnsDistinct;
        }

        private void clear() {
            this.headers.clear();
            this.rows.clear();
        }

        private List<String> getRow(int rowIndex) {
            if (rowIndex > this.rows.size() - 1) {
                throw new RowNotFound(rowIndex);
            }
            return this.rows.get(rowIndex);
        }

        private List<String> getColumn(int columnIndex) {
            return this.rows.stream().map(row -> (String)row.get(columnIndex)).collect(Collectors.toList());
        }

        private List<String> getColumn(String columnName) {
            int[] headerIndexes = IntStream.range(0, this.headers.size()).filter(i -> this.headers.get(i).equals(columnName)).toArray();
            long headerCount = headerIndexes.length;
            if (headerCount == 0L) {
                throw new ColumnNotFound(columnName);
            }
            if (headerCount > 1L) {
                throw new NonDistinctColumnFound(columnName, headerCount);
            }
            return this.getColumn(headerIndexes[0]);
        }
    }

    public static class NonDistinctColumnFound
    extends RuntimeException {
        static final long serialVersionUID = -6898791308443992005L;

        public NonDistinctColumnFound(String columnName, long totalColumnCount) {
            super(String.format("There are %d columns with the name '%s'", totalColumnCount, columnName));
        }

        public NonDistinctColumnFound(String message) {
            super(message);
        }
    }

    public static class ColumnNotFound
    extends RuntimeException {
        static final long serialVersionUID = -6008855238823273059L;

        public ColumnNotFound(String columnName) {
            super(String.format("The '%s' column does not exist", columnName));
        }
    }

    public static class RowNotFound
    extends RuntimeException {
        static final long serialVersionUID = 6577709350720827070L;

        public RowNotFound(int rowIndex) {
            super(Integer.toString(rowIndex));
        }
    }
}

