/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Deque;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.NullTableTransformerMonitor;
import org.jbehave.core.model.TableParsers;
import org.jbehave.core.model.TableTransformerMonitor;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;

public class ExamplesTableFactory {
    private Keywords keywords;
    private final ResourceLoader resourceLoader;
    private final ParameterConverters parameterConverters;
    private final ParameterControls parameterControls;
    private final TableParsers tableParsers;
    private final TableTransformers tableTransformers;
    private final TableTransformerMonitor tableTransformerMonitor;

    public ExamplesTableFactory(ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), resourceLoader, tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(keywords, resourceLoader, new ParameterConverters(resourceLoader, tableTransformers), tableTransformers);
    }

    private ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters, TableTransformers tableTransformers) {
        this(keywords, resourceLoader, parameterConverters, new ParameterControls(), new TableParsers(keywords, parameterConverters), tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers) {
        this(keywords, resourceLoader, parameterConverters, parameterControls, tableParsers, tableTransformers, new NullTableTransformerMonitor());
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers, TableTransformerMonitor tableTransformerMonitor) {
        this.keywords = keywords;
        this.resourceLoader = resourceLoader;
        this.parameterConverters = parameterConverters;
        this.parameterControls = parameterControls;
        this.tableParsers = tableParsers;
        this.tableTransformers = tableTransformers;
        this.tableTransformerMonitor = tableTransformerMonitor;
    }

    public ExamplesTableFactory(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.resourceLoader = configuration.storyLoader();
        this.parameterConverters = configuration.parameterConverters();
        this.parameterControls = configuration.parameterControls();
        this.tableParsers = configuration.tableParsers();
        this.tableTransformers = configuration.tableTransformers();
        this.tableTransformerMonitor = configuration.tableTransformerMonitor();
    }

    public ExamplesTable createExamplesTable(String input) {
        Deque<ExamplesTable.TableProperties> properties;
        ExamplesTable.TablePropertiesQueue tablePropertiesQueue = this.tableParsers.parseProperties(input);
        String tableAsString = tablePropertiesQueue.getTable().trim();
        if (!this.isTable(tableAsString, (properties = tablePropertiesQueue.getProperties()).peekFirst()) && !tableAsString.isEmpty()) {
            String loadedTable = this.resourceLoader.loadResourceAsText(tableAsString.trim());
            tablePropertiesQueue = this.tableParsers.parseProperties(loadedTable);
            Deque<ExamplesTable.TableProperties> target = tablePropertiesQueue.getProperties();
            properties.descendingIterator().forEachRemaining(target::addFirst);
        }
        return new ExamplesTable(tablePropertiesQueue, this.parameterConverters, this.parameterControls, this.tableParsers, this.tableTransformers, this.tableTransformerMonitor);
    }

    protected boolean isTable(String table, ExamplesTable.TableProperties properties) {
        String headerSeparator = properties == null ? this.keywords.examplesTableHeaderSeparator() : properties.getHeaderSeparator();
        return table.startsWith(headerSeparator);
    }

    public void useKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    public Keywords keywords() {
        return this.keywords;
    }
}

