/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Conditional;
import org.jbehave.core.annotations.FromContext;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.ToContext;
import org.jbehave.core.condition.StepConditionMatchException;
import org.jbehave.core.condition.StepConditionMatcher;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.expressions.ExpressionResolver;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.IgnoringStepsFailure;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Verbatim;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;
import org.jbehave.core.steps.Timer;
import org.jbehave.core.steps.context.StepsContext;

public class StepCreator {
    public static final String PARAMETER_TABLE_START = "\uff3b";
    public static final String PARAMETER_TABLE_END = "\uff3d";
    public static final String PARAMETER_VERBATIM_START = "\u301a";
    public static final String PARAMETER_VERBATIM_END = "\u301b";
    public static final String PARAMETER_VALUE_START = "\uff5f";
    public static final String PARAMETER_VALUE_END = "\uff60";
    public static final String PARAMETER_VALUE_NEWLINE = "\u2424";
    public static final UUIDExceptionWrapper NO_FAILURE = new UUIDExceptionWrapper("no failure");
    private static final String NEWLINE = "\n";
    private static final String SPACE = " ";
    private static final String NONE = "";
    private final Class<?> stepsType;
    private final InjectableStepsFactory stepsFactory;
    private final ParameterConverters parameterConverters;
    private final ExpressionResolver expressionResolver;
    private final ParameterControls parameterControls;
    private final Pattern delimitedNamePattern;
    private final StepMatcher stepMatcher;
    private final StepsContext stepsContext;
    private final boolean dryRun;
    private StepMonitor stepMonitor;
    private Paranamer paranamer = new NullParanamer();

    public StepCreator(Class<?> stepsType, InjectableStepsFactory stepsFactory, StepsContext stepsContext, ParameterConverters parameterConverters, ExpressionResolver expressionResolver, ParameterControls parameterControls, StepMatcher stepMatcher, StepMonitor stepMonitor, boolean dryRun) {
        this.stepsType = stepsType;
        this.stepsFactory = stepsFactory;
        this.stepsContext = stepsContext;
        this.parameterConverters = parameterConverters;
        this.expressionResolver = expressionResolver;
        this.parameterControls = parameterControls;
        this.stepMatcher = stepMatcher;
        this.stepMonitor = stepMonitor;
        this.delimitedNamePattern = Pattern.compile(parameterControls.nameDelimiterLeft() + "([\\w\\-\\h.]+?)" + parameterControls.nameDelimiterRight(), 32);
        this.dryRun = dryRun;
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public void useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
    }

    public Object stepsInstance() {
        return this.stepsFactory.createInstanceOfType(this.stepsType);
    }

    public Step createBeforeOrAfterStep(Method method, Meta meta) {
        return new BeforeOrAfterStep(method, meta);
    }

    public Step createAfterStepUponOutcome(Method method, AfterScenario.Outcome outcome, Meta storyAndScenarioMeta) {
        Step beforeOrAfterStep = this.createBeforeOrAfterStep(method, storyAndScenarioMeta);
        return this.wrapStepUponOutcome(outcome, beforeOrAfterStep);
    }

    public Map<String, String> matchedParameters(Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        HashMap<String, String> matchedParameters = new HashMap<String, String>();
        Matcher matcher = this.stepMatcher.matcher(stepWithoutStartingWord);
        if (matcher.find()) {
            ParameterName[] parameterNames = this.parameterNames(method);
            Type[] types = this.parameterTypes(method, parameterNames);
            String[] values = this.parameterValuesForStep(matcher, namedParameters, types, parameterNames, false);
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i].name;
                if (name == null) {
                    name = this.stepMatcher.parameterNames()[i];
                }
                matchedParameters.put(name, values[i]);
            }
        }
        return matchedParameters;
    }

    private ParameterName[] parameterNames(Method method) {
        ParameterName[] parameterNames;
        if (method != null) {
            String[] annotatedNames = this.annotatedParameterNames(method);
            String[] paranamerNames = this.paranamerParameterNames(method);
            String[] contextNames = this.contextParameterNames(method);
            parameterNames = new ParameterName[annotatedNames.length];
            for (int i = 0; i < annotatedNames.length; ++i) {
                parameterNames[i] = this.parameterName(annotatedNames, paranamerNames, contextNames, i);
            }
        } else {
            String[] stepMatcherParameterNames = this.stepMatcher.parameterNames();
            parameterNames = new ParameterName[stepMatcherParameterNames.length];
            for (int i = 0; i < stepMatcherParameterNames.length; ++i) {
                parameterNames[i] = new ParameterName(stepMatcherParameterNames[i], false, false);
            }
        }
        return parameterNames;
    }

    private ParameterName parameterName(String[] annotatedNames, String[] paranamerNames, String[] contextNames, int i) {
        boolean annotated = true;
        boolean fromContext = false;
        String name = contextNames[i];
        if (name != null) {
            fromContext = true;
        } else {
            name = annotatedNames[i];
            if (name == null) {
                name = paranamerNames.length > i ? paranamerNames[i] : null;
                annotated = false;
            }
        }
        return new ParameterName(name, annotated, fromContext);
    }

    private String[] annotatedParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                names[i] = this.annotationName(annotation);
            }
        }
        return names;
    }

    private String[] contextParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                names[i] = this.contextName(annotation);
            }
        }
        return names;
    }

    private String annotationName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(Named.class)) {
            return ((Named)annotation).value();
        }
        if ("javax.inject.Named".equals(annotation.annotationType().getName())) {
            return Jsr330Helper.getNamedValue(annotation);
        }
        return null;
    }

    private String contextName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(FromContext.class)) {
            return ((FromContext)annotation).value();
        }
        return null;
    }

    private String[] paranamerParameterNames(Method method) {
        return this.paranamer.lookupParameterNames((AccessibleObject)method, false);
    }

    private Type[] parameterTypes(Method method, ParameterName[] parameterNames) {
        if (method != null) {
            return method.getGenericParameterTypes();
        }
        Type[] types = new Type[parameterNames.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = String.class;
        }
        return types;
    }

    public Step createConditionalStep(StepConditionMatcher stepConditionMatcher, Map<Method, ParametrisedStep> parametrisedSteps) {
        return new ConditionalStep(stepConditionMatcher, parametrisedSteps);
    }

    public Step createParametrisedStep(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters, List<Step> composedSteps) {
        return new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters, composedSteps);
    }

    public Step createParametrisedStepUponOutcome(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters, List<Step> composedSteps, AfterScenario.Outcome outcome) {
        Step parametrisedStep = this.createParametrisedStep(method, stepAsString, stepWithoutStartingWord, namedParameters, composedSteps);
        return this.wrapStepUponOutcome(outcome, parametrisedStep);
    }

    private Step wrapStepUponOutcome(AfterScenario.Outcome outcome, Step step) {
        switch (outcome) {
            case ANY: {
                return new UponAnyStep(step);
            }
            case SUCCESS: {
                return new UponSuccessStep(step);
            }
            case FAILURE: {
                return new UponFailureStep(step);
            }
        }
        return step;
    }

    private String parametrisedStep(String stepAsString, Map<String, String> namedParameters, Type[] types, String[] parameterValues) {
        String parametrisedStep = stepAsString;
        boolean hasTable = this.hasTable(types);
        for (int position = 0; position < types.length; ++position) {
            parametrisedStep = this.markParsedParameterValue(parametrisedStep, types[position], parameterValues[position], hasTable);
        }
        for (Map.Entry<String, String> namedParameter : namedParameters.entrySet()) {
            parametrisedStep = this.parameterControls.replaceAllDelimitedNames(parametrisedStep, namedParameter.getKey(), this.markedValue(namedParameter.getValue()));
        }
        return parametrisedStep;
    }

    private boolean hasTable(Type[] types) {
        for (Type type : types) {
            if (!this.isTable(type)) continue;
            return true;
        }
        return false;
    }

    private String markParsedParameterValue(String stepText, Type type, String value, boolean hasTable) {
        if (value != null) {
            if (value.trim().length() != 0) {
                if (this.isTable(type)) {
                    return stepText.replace(value, this.markedTable(value));
                }
                if (this.isVerbatim(type)) {
                    return stepText.replace(value, this.markedVerbatim(value));
                }
                String markedValue = this.markedValue(value);
                String leftPad = SPACE;
                String rightPad = stepText.endsWith(value) ? NONE : SPACE;
                return stepText.replace(this.pad(value, leftPad, rightPad), this.pad(markedValue, leftPad, rightPad));
            }
            if (!hasTable) {
                return stepText.replace(NEWLINE, PARAMETER_VALUE_NEWLINE);
            }
        }
        return stepText;
    }

    private String markedTable(String value) {
        return this.pad(value, PARAMETER_TABLE_START, PARAMETER_TABLE_END);
    }

    private String markedVerbatim(String value) {
        return this.pad(value, PARAMETER_VERBATIM_START, PARAMETER_VERBATIM_END);
    }

    private String markedValue(String value) {
        return this.pad(value, PARAMETER_VALUE_START, PARAMETER_VALUE_END);
    }

    private String pad(String value, String left, String right) {
        return left + value + right;
    }

    private boolean isTable(Type type) {
        return this.isExamplesTable(type) || ParameterConverters.ExamplesTableParametersConverter.isExamplesTableParameters(type);
    }

    private boolean isVerbatim(Type type) {
        return type instanceof Class && Verbatim.class.isAssignableFrom((Class)type);
    }

    private boolean isExamplesTable(Type type) {
        return type instanceof Class && ExamplesTable.class.isAssignableFrom((Class)type);
    }

    private String[] parameterValuesForStep(Matcher matcher, Map<String, String> namedParameters, Type[] types, ParameterName[] names, boolean overrideWithTableParameters) {
        String[] parameters = new String[types.length];
        for (int position = 0; position < types.length; ++position) {
            parameters[position] = this.parameterForPosition(matcher, position, names, namedParameters, overrideWithTableParameters);
        }
        return parameters;
    }

    private String parameterForPosition(Matcher matcher, int position, ParameterName[] names, Map<String, String> namedParameters, boolean overrideWithTableParameters) {
        int namePosition = this.parameterPosition(names, position);
        String parameter = null;
        if (namePosition != -1) {
            String name = names[position].name;
            boolean annotated = names[position].annotated;
            boolean fromContext = names[position].fromContext;
            List<String> delimitedNames = Collections.emptyList();
            if (this.isGroupName(name) && (delimitedNames = this.delimitedNameFor(parameter = this.matchedParameter(matcher, name))).isEmpty()) {
                this.monitorUsingNameForParameter(name, position, annotated);
            }
            if (!delimitedNames.isEmpty()) {
                parameter = this.replaceAllDelimitedNames(delimitedNames, position, annotated, parameter, namedParameters);
                delimitedNames = this.delimitedNameFor(parameter);
                parameter = this.replaceAllDelimitedNames(delimitedNames, position, annotated, parameter, namedParameters);
            } else if (overrideWithTableParameters && namedParameters.containsKey(name) && (parameter = namedParameters.get(name)) != null) {
                this.monitorUsingTableNameForParameter(name, position, annotated);
            }
            if (fromContext && parameter == null) {
                parameter = name;
                this.stepMonitor.usingStepsContextParameter(parameter);
            }
        }
        if (parameter == null) {
            String previousParameterValue;
            position -= this.numberOfPreviousFromContext(names, position);
            this.stepMonitor.usingNaturalOrderForParameter(position);
            parameter = this.matchedParameter(matcher, position);
            do {
                previousParameterValue = parameter;
                for (String delimitedName : this.delimitedNameFor(parameter)) {
                    parameter = this.replaceAllDelimitedNames(parameter, delimitedName, namedParameters);
                }
            } while (parameter != null && !previousParameterValue.equals(parameter));
        }
        this.stepMonitor.foundParameter(parameter, position);
        return parameter;
    }

    private String replaceAllDelimitedNames(List<String> delimitedNames, int position, boolean annotated, String parameter, Map<String, String> namedParameters) {
        String parameterWithDelimitedNames = parameter;
        for (String delimitedName : delimitedNames) {
            this.monitorUsingTableNameForParameter(delimitedName, position, annotated);
            parameterWithDelimitedNames = this.replaceAllDelimitedNames(parameterWithDelimitedNames, delimitedName, namedParameters);
        }
        return parameterWithDelimitedNames;
    }

    private String replaceAllDelimitedNames(String parameterWithDelimitedNames, String delimitedName, Map<String, String> namedParameters) {
        if (namedParameters.containsKey(delimitedName)) {
            return this.parameterControls.replaceAllDelimitedNames(parameterWithDelimitedNames, delimitedName, namedParameters.get(delimitedName));
        }
        return parameterWithDelimitedNames;
    }

    private int numberOfPreviousFromContext(ParameterName[] names, int currentPosition) {
        int number = 0;
        for (int i = currentPosition - 1; i >= 0; --i) {
            if (!names[i].fromContext) continue;
            ++number;
        }
        return number;
    }

    private void monitorUsingTableNameForParameter(String name, int position, boolean usingAnnotationNames) {
        if (usingAnnotationNames) {
            this.stepMonitor.usingTableAnnotatedNameForParameter(name, position);
        } else {
            this.stepMonitor.usingTableParameterNameForParameter(name, position);
        }
    }

    private void monitorUsingNameForParameter(String name, int position, boolean usingAnnotationNames) {
        if (usingAnnotationNames) {
            this.stepMonitor.usingAnnotatedNameForParameter(name, position);
        } else {
            this.stepMonitor.usingParameterNameForParameter(name, position);
        }
    }

    private List<String> delimitedNameFor(String parameter) {
        ArrayList<String> delimitedNames = new ArrayList<String>();
        if (this.parameterControls.delimiterNamedParameters()) {
            Matcher matcher = this.delimitedNamePattern.matcher(parameter);
            while (matcher.find()) {
                delimitedNames.add(matcher.group(1));
            }
        }
        return delimitedNames;
    }

    String matchedParameter(Matcher matcher, String name) {
        String[] parameterNames = this.stepMatcher.parameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (!name.equals(parameterName)) continue;
            return this.matchedParameter(matcher, i);
        }
        throw new ParameterNotFound(name, parameterNames);
    }

    private String matchedParameter(Matcher matcher, int position) {
        int matchedPosition = position + 1;
        String[] parameterNames = this.stepMatcher.parameterNames();
        if (matchedPosition <= parameterNames.length) {
            return matcher.group(matchedPosition);
        }
        throw new ParameterNotFound(position, parameterNames);
    }

    private int parameterPosition(ParameterName[] names, int position) {
        if (names.length == 0) {
            return -1;
        }
        String positionName = names[position].name;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].name;
            if (name == null || !name.equals(positionName)) continue;
            return i;
        }
        return -1;
    }

    private boolean isGroupName(String name) {
        String[] groupNames;
        for (String groupName : groupNames = this.stepMatcher.parameterNames()) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public static Step createPendingStep(String stepAsString, String previousNonAndStep) {
        return new PendingStep(stepAsString, previousNonAndStep);
    }

    public static Step createIgnorableStep(String stepAsString) {
        return new IgnorableStep(stepAsString);
    }

    public static Step createComment(String stepAsString) {
        return new Comment(stepAsString);
    }

    private void storeOutput(Object object, Method method) {
        ToContext annotation = method.getAnnotation(ToContext.class);
        if (annotation != null) {
            this.stepsContext.put(annotation.value(), object, annotation.retentionLevel());
        }
    }

    private static class ParameterName {
        private String name;
        private boolean annotated;
        private boolean fromContext;

        private ParameterName(String name, boolean annotated, boolean fromContext) {
            this.name = name;
            this.annotated = annotated;
            this.fromContext = fromContext;
        }
    }

    private class BeforeOrAfterStep
    extends ReportingAbstractStep {
        private final Method method;
        private final Meta meta;

        public BeforeOrAfterStep(Method method, Meta meta) {
            super(StepExecutionType.EXECUTABLE, method.getName());
            this.method = method;
            this.meta = meta;
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            ParameterConverters paramConvertersWithExceptionInjector = this.paramConvertersWithExceptionInjector(storyFailureIfItHappened);
            MethodInvoker methodInvoker = new MethodInvoker(this.method, paramConvertersWithExceptionInjector, StepCreator.this.paranamer, this.meta);
            Timer timer = new Timer().start();
            try {
                Object outputObject = methodInvoker.invoke();
                StepCreator.this.storeOutput(outputObject, this.method);
                return AbstractStepResult.successful(this.method).setTimings(timer.stop());
            }
            catch (InvocationTargetException e) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, e.getCause()))).setTimings(timer.stop());
            }
            catch (Throwable t) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, t))).setTimings(timer.stop());
            }
        }

        private ParameterConverters paramConvertersWithExceptionInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
            return StepCreator.this.parameterConverters.newInstanceAdding(new UUIDExceptionWrapperInjector(storyFailureIfItHappened));
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyReporter, storyFailureIfItHappened);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.method.getName() + ";" + this.meta.asString(keywords);
        }

        private class UUIDExceptionWrapperInjector
        extends ParameterConverters.FromStringParameterConverter<UUIDExceptionWrapper> {
            private final UUIDExceptionWrapper storyFailureIfItHappened;

            public UUIDExceptionWrapperInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
                this.storyFailureIfItHappened = storyFailureIfItHappened;
            }

            @Override
            public boolean canConvertTo(Type type) {
                return UUIDExceptionWrapper.class == type;
            }

            @Override
            public UUIDExceptionWrapper convertValue(String value, Type type) {
                return this.storyFailureIfItHappened;
            }
        }
    }

    public static class Jsr330Helper {
        private static String getNamedValue(Annotation annotation) {
            return ((javax.inject.Named)annotation).value();
        }
    }

    public class ConditionalStep
    extends AbstractStep {
        private final StepConditionMatcher stepConditionMatcher;
        private final Map<Method, ParametrisedStep> parametrisedSteps;

        public ConditionalStep(StepConditionMatcher stepConditionMatcher, Map<Method, ParametrisedStep> parametrisedSteps) {
            this.stepConditionMatcher = stepConditionMatcher;
            this.parametrisedSteps = parametrisedSteps;
        }

        @Override
        public StepResult perform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.performConditionalStep(storyReporter, step -> step.perform(storyReporter, storyFailureIfItHappened));
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.performConditionalStep(storyReporter, step -> step.doNotPerform(storyReporter, storyFailureIfItHappened));
        }

        private StepResult performConditionalStep(StoryReporter storyReporter, Function<ParametrisedStep, StepResult> invoker) {
            try {
                String message;
                HashMap<Method, Conditional> unmatchedSteps = new HashMap<Method, Conditional>();
                HashMap<Method, Conditional> matchedSteps = new HashMap<Method, Conditional>();
                for (Method method : this.parametrisedSteps.keySet()) {
                    Conditional conditional = Optional.ofNullable(method.getAnnotation(Conditional.class)).orElseGet(() -> method.getDeclaringClass().getAnnotation(Conditional.class));
                    HashMap<Method, Conditional> target = this.stepConditionMatcher.matches(conditional.condition(), conditional.value()) ? matchedSteps : unmatchedSteps;
                    target.put(method, conditional);
                }
                if (matchedSteps.isEmpty()) {
                    message = this.getStepName() + System.lineSeparator() + "None of the following steps were matched any condition:" + System.lineSeparator() + this.formatSteps(unmatchedSteps);
                    return this.reportPending(storyReporter, message);
                }
                if (matchedSteps.size() > 1) {
                    message = this.getStepName() + System.lineSeparator() + "More than one conditional step matched the condition:" + System.lineSeparator() + this.formatSteps(matchedSteps);
                    return this.reportPending(storyReporter, message);
                }
                return invoker.apply(this.parametrisedSteps.get(matchedSteps.keySet().iterator().next()));
            }
            catch (StepConditionMatchException e) {
                return this.reportPending(storyReporter, this.getStepName() + System.lineSeparator() + e.getMessage());
            }
        }

        private StepResult reportPending(StoryReporter storyReporter, String message) {
            Step pendingStep = StepCreator.createPendingStep(message, null);
            return pendingStep.perform(storyReporter, null);
        }

        private String formatSteps(Map<Method, Conditional> matchedSteps) {
            return matchedSteps.entrySet().stream().map(e -> this.formatStep((Method)e.getKey(), (Conditional)e.getValue())).collect(Collectors.joining(System.lineSeparator()));
        }

        private String formatStep(Method method, Conditional condition) {
            return method.getDeclaringClass() + "." + method.getName() + " (condition: " + condition.condition() + StepCreator.SPACE + condition.value() + ")";
        }

        private String getStepName() {
            return this.parametrisedSteps.values().iterator().next().asString(null);
        }
    }

    public class ParametrisedStep
    extends ReportingAbstractStep {
        private String parametrisedStep;
        private final Method method;
        private final String stepWithoutStartingWord;
        private final Map<String, String> namedParameters;
        private final List<Step> composedSteps;

        public ParametrisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters, List<Step> composedSteps) {
            super(StepExecutionType.EXECUTABLE, stepAsString);
            this.method = method;
            this.stepWithoutStartingWord = stepWithoutStartingWord;
            this.namedParameters = namedParameters;
            this.composedSteps = composedSteps;
        }

        @Override
        public List<Step> getComposedSteps() {
            return this.composedSteps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailure) {
            String stepAsString = this.getStepAsString();
            Timer timer = new Timer().start();
            try {
                Object outputObject;
                Object[] convertedParameters = this.parametriseStep();
                StepCreator.this.stepMonitor.beforePerforming(this.parametrisedStep, StepCreator.this.dryRun, this.method);
                if (!StepCreator.this.dryRun && this.method != null) {
                    outputObject = this.method.invoke(StepCreator.this.stepsInstance(), convertedParameters);
                    StepCreator.this.storeOutput(outputObject, this.method);
                }
                outputObject = AbstractStepResult.successful(stepAsString).withParameterValues(this.parametrisedStep).setTimings(timer.stop());
                return outputObject;
            }
            catch (ParameterNotFound e) {
                StepResult outputObject = AbstractStepResult.pending(new PendingStep(stepAsString, null)).withParameterValues(this.parametrisedStep);
                return outputObject;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RestartingScenarioFailure) {
                    throw (RestartingScenarioFailure)e.getCause();
                }
                if (e.getCause() instanceof IgnoringStepsFailure) {
                    throw (IgnoringStepsFailure)e.getCause();
                }
                Throwable failureCause = e.getCause();
                if (failureCause instanceof UUIDExceptionWrapper) {
                    failureCause = failureCause.getCause();
                }
                StepResult stepResult = AbstractStepResult.failed(stepAsString, new UUIDExceptionWrapper(stepAsString, failureCause)).withParameterValues(this.parametrisedStep).setTimings(timer.stop());
                return stepResult;
            }
            catch (Throwable t) {
                StepResult stepResult = AbstractStepResult.failed(stepAsString, new UUIDExceptionWrapper(stepAsString, t)).withParameterValues(this.parametrisedStep).setTimings(timer.stop());
                return stepResult;
            }
            finally {
                StepCreator.this.stepMonitor.afterPerforming(this.parametrisedStep, StepCreator.this.dryRun, this.method);
            }
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            storyReporter.beforeStep(new org.jbehave.core.model.Step(StepExecutionType.NOT_PERFORMED, this.getStepAsString()));
            try {
                this.parametriseStep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return AbstractStepResult.notPerformed(this.getStepAsString()).withParameterValues(this.parametrisedStep);
        }

        @Override
        public String asString(Keywords keywords) {
            if (this.parametrisedStep == null) {
                this.parametriseStep();
            }
            return this.parametrisedStep;
        }

        private Object[] parametriseStep() {
            Matcher matcher = StepCreator.this.stepMatcher.matcher(this.stepWithoutStartingWord);
            matcher.find();
            ParameterName[] names = StepCreator.this.parameterNames(this.method);
            Type[] types = StepCreator.this.parameterTypes(this.method, names);
            Object[] parameterValues = StepCreator.this.parameterValuesForStep(matcher, this.namedParameters, types, names, true);
            Object[] convertedParameters = this.method == null ? parameterValues : this.convertParameterValues((String[])parameterValues, types, names);
            this.addNamedParametersToExamplesTables(convertedParameters);
            this.parametrisedStep = StepCreator.this.parametrisedStep(this.getStepAsString(), this.namedParameters, types, (String[])parameterValues);
            return convertedParameters;
        }

        private Object[] convertParameterValues(String[] parameterValues, Type[] types, ParameterName[] names) {
            Object[] parameters = new Object[parameterValues.length];
            for (int i = 0; i < parameterValues.length; ++i) {
                String parameterValue = parameterValues[i];
                if (names[i].fromContext) {
                    parameters[i] = StepCreator.this.stepsContext.get(parameterValue);
                    continue;
                }
                String expressionEvaluationResult = parameterValue != null ? String.valueOf(StepCreator.this.expressionResolver.resolveExpressions(StepCreator.this.dryRun, parameterValue)) : null;
                parameters[i] = StepCreator.this.parameterConverters.convert(expressionEvaluationResult, types[i]);
            }
            return parameters;
        }

        private void addNamedParametersToExamplesTables(Object[] convertedParameters) {
            Stream.of(convertedParameters).filter(ExamplesTable.class::isInstance).map(ExamplesTable.class::cast).forEach(examplesTable -> examplesTable.withNamedParameters(this.namedParameters));
        }
    }

    class UponAnyStep
    extends DelegatingStep {
        UponAnyStep(Step step) {
            super(step);
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyReporter, storyFailureIfItHappened);
        }
    }

    class UponSuccessStep
    extends DelegatingStep {
        UponSuccessStep(Step step) {
            super(step);
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }
    }

    class UponFailureStep
    extends DelegatingStep {
        UponFailureStep(Step step) {
            super(step);
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return super.perform(storyReporter, storyFailureIfItHappened);
        }

        @Override
        public StepResult perform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }
    }

    public static class ParameterNotFound
    extends RuntimeException {
        public ParameterNotFound(String name, String[] parameters) {
            super("Parameter not found for name '" + name + "' amongst '" + Arrays.asList(parameters) + "'");
        }

        public ParameterNotFound(int position, String[] parameters) {
            super("Parameter not found for position '" + position + "' amongst '" + Arrays.asList(parameters) + "'");
        }
    }

    public static class PendingStep
    extends ReportingAbstractStep {
        private final String previousNonAndStep;
        private Method method;
        private String pendingMethod;

        public PendingStep(String stepAsString, String previousNonAndStep) {
            super(StepExecutionType.PENDING, stepAsString);
            this.previousNonAndStep = previousNonAndStep;
        }

        @Override
        protected StepResult perform(UUIDExceptionWrapper storyFailure) {
            return AbstractStepResult.pending(this);
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyReporter, storyFailureIfItHappened);
        }

        public String stepAsString() {
            return this.getStepAsString();
        }

        public String previousNonAndStepAsString() {
            return this.previousNonAndStep;
        }

        public void annotatedOn(Method method) {
            this.method = method;
        }

        public boolean annotated() {
            return this.method != null;
        }

        public String getPendingMethod() {
            return this.pendingMethod;
        }

        public void setPendingMethod(String pendingMethod) {
            this.pendingMethod = pendingMethod;
        }
    }

    public static class IgnorableStep
    extends ReportingAbstractStep {
        public IgnorableStep(String stepAsString) {
            super(StepExecutionType.IGNORABLE, stepAsString);
        }

        @Override
        protected StepResult perform(UUIDExceptionWrapper storyFailure) {
            return AbstractStepResult.ignorable(this.getStepAsString());
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyReporter, storyFailureIfItHappened);
        }
    }

    public static class Comment
    extends ReportingAbstractStep {
        public Comment(String stepAsString) {
            super(StepExecutionType.COMMENT, stepAsString);
        }

        @Override
        protected StepResult perform(UUIDExceptionWrapper storyFailure) {
            return AbstractStepResult.comment(this.getStepAsString());
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyReporter, storyFailureIfItHappened);
        }
    }

    private class MethodInvoker {
        private final Method method;
        private final ParameterConverters parameterConverters;
        private final Paranamer paranamer;
        private final Meta meta;
        private final Type[] parameterTypes;

        public MethodInvoker(Method method, ParameterConverters parameterConverters, Paranamer paranamer, Meta meta) {
            this.method = method;
            this.parameterConverters = parameterConverters;
            this.paranamer = paranamer;
            this.meta = meta;
            this.parameterTypes = method.getGenericParameterTypes();
        }

        public Object invoke() throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(StepCreator.this.stepsInstance(), this.parameterValuesFrom(this.meta));
        }

        private Parameter[] methodParameters() {
            Parameter[] parameters = new Parameter[this.parameterTypes.length];
            String[] annotatedNames = StepCreator.this.annotatedParameterNames(this.method);
            String[] paranamerNames = this.paranamer.lookupParameterNames((AccessibleObject)this.method, false);
            for (int position = 0; position < this.parameterTypes.length; ++position) {
                String name = this.parameterNameFor(position, annotatedNames, paranamerNames);
                parameters[position] = new Parameter(position, this.parameterTypes[position], name);
            }
            return parameters;
        }

        private String parameterNameFor(int position, String[] annotatedNames, String[] paranamerNames) {
            String annotatedName = this.nameByPosition(annotatedNames, position);
            String paranamerName = this.nameByPosition(paranamerNames, position);
            if (annotatedName != null) {
                return annotatedName;
            }
            if (paranamerName != null) {
                return paranamerName;
            }
            return null;
        }

        private String nameByPosition(String[] names, int position) {
            return position < names.length ? names[position] : null;
        }

        private Object[] parameterValuesFrom(Meta meta) {
            Object[] values = new Object[this.parameterTypes.length];
            for (Parameter parameter : this.methodParameters()) {
                values[((Parameter)parameter).position] = this.parameterConverters.convert(parameter.valueFrom(meta), parameter.type);
            }
            return values;
        }

        private class Parameter {
            private final int position;
            private final Type type;
            private final String name;

            public Parameter(int position, Type type, String name) {
                this.position = position;
                this.type = type;
                this.name = name;
            }

            public String valueFrom(Meta meta) {
                if (this.name == null) {
                    return null;
                }
                return meta.getProperty(this.name);
            }
        }
    }

    public static enum StepExecutionType {
        EXECUTABLE,
        PENDING,
        IGNORABLE,
        COMMENT,
        NOT_PERFORMED;

    }

    static class DelegatingStep
    extends AbstractStep {
        private final Step step;

        DelegatingStep(Step step) {
            this.step = step;
        }

        @Override
        public StepResult perform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.step.perform(storyReporter, storyFailureIfItHappened);
        }

        @Override
        public StepResult doNotPerform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.step.doNotPerform(storyReporter, storyFailureIfItHappened);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.step.asString(keywords);
        }

        @Override
        public List<Step> getComposedSteps() {
            return this.step.getComposedSteps();
        }
    }

    public static abstract class ReportingAbstractStep
    extends AbstractStep {
        private final StepExecutionType stepExecutionType;
        private final String stepAsString;

        public ReportingAbstractStep(StepExecutionType stepExecutionType, String stepAsString) {
            this.stepExecutionType = stepExecutionType;
            this.stepAsString = stepAsString;
        }

        @Override
        public final StepResult perform(StoryReporter storyReporter, UUIDExceptionWrapper storyFailure) {
            storyReporter.beforeStep(new org.jbehave.core.model.Step(this.stepExecutionType, this.getStepAsString()));
            return this.perform(storyFailure);
        }

        protected abstract StepResult perform(UUIDExceptionWrapper var1);

        @Override
        public String asString(Keywords keywords) {
            return this.stepAsString;
        }

        protected String getStepAsString() {
            return this.stepAsString;
        }
    }

    public static abstract class AbstractStep
    implements Step {
        @Override
        public String asString(Keywords keywords) {
            return this.toString();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }

        @Override
        public List<Step> getComposedSteps() {
            return Collections.emptyList();
        }
    }
}

