/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.condition.ReflectionBasedStepConditionMatcher;
import org.jbehave.core.condition.StepConditionMatcher;
import org.jbehave.core.embedder.AllStepCandidates;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.Stepdoc;
import org.jbehave.core.steps.Steps;

public class StepFinder {
    private final PrioritisingStrategy prioritisingStrategy;
    private final StepConditionMatcher stepConditionMatcher;

    public StepFinder() {
        this(new ByPriorityField());
    }

    public StepFinder(PrioritisingStrategy prioritisingStrategy) {
        this.prioritisingStrategy = prioritisingStrategy;
        this.stepConditionMatcher = new ReflectionBasedStepConditionMatcher();
    }

    public StepFinder(StepConditionMatcher stepConditionMatcher) {
        this.prioritisingStrategy = new ByPriorityField();
        this.stepConditionMatcher = stepConditionMatcher;
    }

    public List<Stepdoc> stepdocs(List<CandidateSteps> candidateSteps) {
        return this.createStepdocs(candidate -> true, candidateSteps);
    }

    public List<Stepdoc> findMatching(String stepAsText, List<CandidateSteps> candidateSteps) {
        return this.createStepdocs(candidate -> candidate.matches(stepAsText), candidateSteps);
    }

    private List<Stepdoc> createStepdocs(Predicate<StepCandidate> candidateFilter, List<CandidateSteps> candidateSteps) {
        return new AllStepCandidates(this.stepConditionMatcher, candidateSteps).getRegularSteps().stream().filter(candidateFilter).map(Stepdoc::new).collect(Collectors.toList());
    }

    public List<Object> stepsInstances(List<CandidateSteps> candidateSteps) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (CandidateSteps steps : candidateSteps) {
            if (!(steps instanceof Steps)) continue;
            instances.add(((Steps)steps).instance());
        }
        return instances;
    }

    public List<StepCandidate> prioritise(String stepAsText, List<StepCandidate> candidates) {
        return this.prioritisingStrategy.prioritise(stepAsText, candidates);
    }

    public static class ByPriorityField
    implements PrioritisingStrategy {
        @Override
        public List<StepCandidate> prioritise(String stepAsText, List<StepCandidate> candidates) {
            Collections.sort(candidates, new Comparator<StepCandidate>(){

                @Override
                public int compare(StepCandidate o1, StepCandidate o2) {
                    return o2.getPriority().compareTo(o1.getPriority());
                }
            });
            return candidates;
        }
    }

    public static interface PrioritisingStrategy {
        public List<StepCandidate> prioritise(String var1, List<StepCandidate> var2);
    }

    public static class ByLevenshteinDistance
    implements PrioritisingStrategy {
        private LevenshteinDistance ld = new LevenshteinDistance();

        @Override
        public List<StepCandidate> prioritise(final String stepAsText, List<StepCandidate> candidates) {
            Collections.sort(candidates, new Comparator<StepCandidate>(){

                @Override
                public int compare(StepCandidate o1, StepCandidate o2) {
                    String scoringPattern1 = this.scoringPattern(o1);
                    String scoringPattern2 = this.scoringPattern(o2);
                    String stepWithoutStartingWord = this.trimStartingWord(stepAsText);
                    Integer score1 = 0 - ld.calculate(scoringPattern1, stepWithoutStartingWord);
                    Integer score2 = 0 - ld.calculate(scoringPattern2, stepWithoutStartingWord);
                    int result = score2.compareTo(score1);
                    return result != 0 ? result : o2.getPriority().compareTo(o1.getPriority());
                }

                private String scoringPattern(StepCandidate candidate) {
                    return candidate.getPatternAsString().replaceAll("\\s\\$\\w+\\s", " ").replaceAll("\\$\\w + ", "");
                }

                private String trimStartingWord(String stepAsString) {
                    return StringUtils.substringAfter((String)stepAsString, (String)" ");
                }
            });
            return candidates;
        }

        private class LevenshteinDistance {
            private LevenshteinDistance() {
            }

            public int calculate(String s, String t) {
                int j;
                int i;
                int n = s.length();
                int m = t.length();
                if (n == 0) {
                    return m;
                }
                if (m == 0) {
                    return n;
                }
                int[][] d = new int[n + 1][m + 1];
                for (i = 0; i <= n; ++i) {
                    d[i][0] = i;
                }
                for (j = 0; j <= m; ++j) {
                    d[0][j] = j;
                }
                for (i = 1; i <= n; ++i) {
                    char s_i = s.charAt(i - 1);
                    for (j = 1; j <= m; ++j) {
                        char t_j = t.charAt(j - 1);
                        int cost = s_i == t_j ? 0 : 1;
                        d[i][j] = this.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
                    }
                }
                return d[n][m];
            }

            private int minimum(int a, int b, int c) {
                int mi = a;
                if (b < mi) {
                    mi = b;
                }
                if (c < mi) {
                    mi = c;
                }
                return mi;
            }
        }
    }
}

