/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.job.model.Job;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.util.BatchUtil;

public final class JobExecutionImpl
extends AbstractExecution
implements JobExecution,
Cloneable {
    private static final long serialVersionUID = 3706885354351337764L;
    private long id;
    private final JobInstanceImpl jobInstance;
    private Job substitutedJob;
    private final List<StepExecution> stepExecutions = new ArrayList<StepExecution>();
    private final Properties jobParameters;
    protected long createTime;
    protected long lastUpdatedTime;
    private String restartPosition;
    private CountDownLatch jobTerminationLatch = new CountDownLatch(1);
    private CountDownLatch jobStopLatch = new CountDownLatch(1);

    public JobExecutionImpl(JobInstanceImpl jobInstance, Properties jobParameters) throws JobStartException {
        this.jobInstance = jobInstance;
        this.jobParameters = jobParameters;
        this.substitutedJob = BatchUtil.clone(jobInstance.unsubstitutedJob);
        this.startTime = this.createTime = System.currentTimeMillis();
        this.setBatchStatus(BatchStatus.STARTING);
    }

    public JobExecutionImpl(JobInstanceImpl jobInstance, long id, Properties jobParameters, Timestamp createTime, Timestamp startTime, Timestamp endTime, Timestamp lastUpdatedTime, String batchStatus, String exitStatus, String restartPosition) {
        this.jobInstance = jobInstance;
        this.jobParameters = jobParameters;
        this.id = id;
        if (createTime != null) {
            this.createTime = createTime.getTime();
        }
        if (startTime != null) {
            this.startTime = startTime.getTime();
        }
        if (endTime != null) {
            this.endTime = endTime.getTime();
        }
        if (lastUpdatedTime != null) {
            this.lastUpdatedTime = lastUpdatedTime.getTime();
        }
        this.batchStatus = BatchStatus.valueOf((String)batchStatus);
        this.exitStatus = exitStatus;
        this.restartPosition = restartPosition;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public JobExecutionImpl clone() {
        JobExecutionImpl result = null;
        try {
            result = (JobExecutionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobName(), "");
        }
        return result;
    }

    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.jobTerminationLatch != null) {
            if (timeout <= 0L) {
                this.jobTerminationLatch.await();
            } else {
                this.jobTerminationLatch.await(timeout, timeUnit);
            }
        }
    }

    public void awaitStop() throws InterruptedException {
        if (this.jobStopLatch != null) {
            this.jobStopLatch.await();
        }
    }

    public Job getSubstitutedJob() {
        return this.substitutedJob;
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public long getExecutionId() {
        return this.id;
    }

    public String getJobName() {
        return this.jobInstance.getJobName();
    }

    public Date getCreateTime() {
        return new Date(this.createTime);
    }

    public Date getLastUpdatedTime() {
        return new Date(this.lastUpdatedTime);
    }

    public JobInstanceImpl getJobInstance() {
        return this.jobInstance;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StepExecution> getStepExecutions() {
        List<StepExecution> list = this.stepExecutions;
        synchronized (list) {
            return Collections.unmodifiableList(this.stepExecutions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStepExecution(StepExecution stepExecution) {
        List<StepExecution> list = this.stepExecutions;
        synchronized (list) {
            this.stepExecutions.add(stepExecution);
        }
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    public void setRestartPosition(String restartPosition) {
        this.restartPosition = restartPosition;
    }

    public String getRestartPosition() {
        return this.restartPosition;
    }

    public boolean isStopRequested() {
        return this.jobStopLatch.getCount() == 0L;
    }

    public void stop() {
        this.jobStopLatch.countDown();
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
        this.lastUpdatedTime = endTime;
    }

    public void cleanUp() {
        this.substitutedJob = null;
        ArtifactCreationContext.removeCurrentArtifactCreationContext();
        this.jobStopLatch.countDown();
        this.jobStopLatch = null;
        this.jobTerminationLatch.countDown();
        this.jobTerminationLatch = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExecutionImpl that = (JobExecutionImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

