/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.tck.impl;

import com.ibm.jbatch.tck.spi.JobExecutionTimeoutException;
import com.ibm.jbatch.tck.spi.JobExecutionWaiter;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import org.jberet.runtime.JobExecutionImpl;

public final class JobExecutionWaiterImpl
implements JobExecutionWaiter {
    private final JobExecutionImpl jobExecution;
    private final long sleepTime;
    private final JobOperator jobOperator;

    JobExecutionWaiterImpl(long executionId, JobOperator jobOp, long sleepTime) {
        try {
            this.jobOperator = jobOp;
            this.jobExecution = (JobExecutionImpl)jobOp.getJobExecution(executionId);
            this.sleepTime = sleepTime;
        }
        catch (JobSecurityException e) {
            throw new IllegalStateException("Failed to create JobExecutionWaiterImpl.", e);
        }
        catch (NoSuchJobExecutionException e) {
            throw new IllegalStateException("Failed to create JobExecutionWaiterImpl.", e);
        }
    }

    public JobExecution awaitTermination() throws JobExecutionTimeoutException {
        try {
            this.jobExecution.awaitTerminatioin(this.sleepTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.printf("awaitTerminatioin for jobName %s, jobExecution %s, timeout %s milliseconds, BatchStatus: %s%n", this.jobExecution.getJobName(), this.jobExecution.getExecutionId(), this.sleepTime, this.jobExecution.getBatchStatus());
        return this.jobExecution;
    }
}

