/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss4;

import java.io.File;
import java.io.FileOutputStream;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtClass;
import org.jboss.aop.asintegration.jboss4.ToClassInvokerPoolReference;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToClassInvoker {
    Logger logger = Logger.getLogger(this.getClass());
    public File tmpDir;
    public Object tmplock = new Object();

    public ToClassInvoker(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> toClass(ToClassInvokerPoolReference pool, CtClass cc, String classFileName, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        boolean trace = this.logger.isTraceEnabled();
        pool.lockInCache(cc);
        ClassLoader myloader = pool.getClassLoader();
        if (myloader == null || this.tmpDir == null) {
            if (trace) {
                this.logger.trace((Object)(this + " " + pool + ".toClass() myloader:" + myloader + " tmpDir:" + this.tmpDir + " default to superPool.toClass for " + cc.getName()));
            }
            Class<?> clazz = pool.superPoolToClass(cc, loader, domain);
            if (trace) {
                this.logger.trace((Object)(this + " " + pool + " myloader:" + myloader + " created class:" + clazz));
            }
            return clazz;
        }
        Class<?> dynClass = null;
        try {
            File classFile = null;
            Object object = this.tmplock;
            synchronized (object) {
                classFile = new File(this.tmpDir, classFileName);
                if (trace) {
                    this.logger.trace((Object)(this + " " + pool + ".toClass() myloader:" + myloader + " writing bytes to " + classFile));
                }
                File pkgDirs = classFile.getParentFile();
                pkgDirs.mkdirs();
                FileOutputStream stream = new FileOutputStream(classFile);
                stream.write(cc.toBytecode());
                stream.flush();
                stream.close();
                classFile.deleteOnExit();
            }
            RepositoryClassLoader rcl = (RepositoryClassLoader)myloader;
            rcl.clearClassBlackList();
            rcl.clearResourceBlackList();
            dynClass = myloader.loadClass(cc.getName());
            if (trace) {
                this.logger.trace((Object)(this + " " + pool + " myloader:" + myloader + " created class:" + dynClass));
            }
            return dynClass;
        }
        catch (Exception ex) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName());
            cfe.initCause(ex);
            throw cfe;
        }
    }
}

