/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.InputStream;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

public class ConfigurationRegistrar {
    static final String ARQUILLIAN_XML_PROPERTY = "arquillian.xml";
    static final String ARQUILLIAN_XML_DEFAULT = "arquillian.xml";
    @Inject
    @ApplicationScoped
    private InstanceProducer<ArquillianDescriptor> descriptorInst;

    public void loadConfiguration(@Observes ManagerStarted event) {
        InputStream input = this.loadArquillianXml();
        ArquillianDescriptor descriptor = input != null ? (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).from(input) : (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
        this.descriptorInst.set((Object)descriptor);
    }

    private InputStream loadArquillianXml() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(this.getConfigFileName());
    }

    private String getConfigFileName() {
        String name = System.getProperty("arquillian.xml");
        if (name == null) {
            name = "arquillian.xml";
        }
        return name;
    }
}

