/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.Collection;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.DeploymentExceptionTransformer;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class DeploymentExceptionHandler {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void verifyExpectedExceptionDuringDeploy(@Observes EventContext<DeployDeployment> context) throws Exception {
        DeploymentDescription deployment = ((DeployDeployment)context.getEvent()).getDeployment().getDescription();
        boolean deploymentExceptionThrown = true;
        try {
            context.proceed();
            if (deployment.getExpectedException() != null) {
                deploymentExceptionThrown = false;
                throw new RuntimeException("Expected exception of type " + deployment.getExpectedException().getName() + " during deployment of " + deployment.getName() + ", but no exception was thrown.");
            }
        }
        catch (Exception e) {
            if (!deploymentExceptionThrown) {
                throw e;
            }
            if (deployment.getExpectedException() != null) {
                if (!this.containsType(this.transform(e), deployment.getExpectedException())) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private boolean containsType(Throwable exception, Class<? extends Exception> expectedType) {
        if (exception == null) {
            return false;
        }
        if (expectedType.isAssignableFrom(exception.getClass())) {
            return true;
        }
        return this.containsType(exception.getCause(), expectedType);
    }

    private Throwable transform(Throwable exception) {
        Throwable toBeTransformed = exception;
        if (exception instanceof DeploymentException) {
            toBeTransformed = exception.getCause();
        }
        Collection transformers = ((ServiceLoader)this.serviceLoader.get()).all(DeploymentExceptionTransformer.class);
        for (DeploymentExceptionTransformer transformer : transformers) {
            Throwable transformed = transformer.transform(toBeTransformed);
            if (transformed == null) continue;
            return transformed;
        }
        return toBeTransformed;
    }
}

