/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.event.KillContainer;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.container.spi.event.SetupContainers;
import org.jboss.arquillian.container.spi.event.StartClassContainers;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopClassContainers;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.StopManualContainers;
import org.jboss.arquillian.container.spi.event.StopSuiteContainers;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerLifecycleController {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<Injector> injector;

    public void setupContainers(@Observes SetupContainers event) throws Exception {
        this.forEachContainer(new Operation<Container>(){
            @Inject
            private Event<SetupContainer> event;

            @Override
            public void perform(Container container) {
                this.event.fire((Object)new SetupContainer(container));
            }
        });
    }

    public void startSuiteContainers(@Observes StartSuiteContainers event) throws Exception {
        this.forEachSuiteContainer(new Operation<Container>(){
            @Inject
            private Event<StartContainer> event;

            @Override
            public void perform(Container container) {
                this.event.fire((Object)new StartContainer(container));
            }
        });
    }

    public void startClassContainers(@Observes StartClassContainers event) throws Exception {
        this.forEachClassContainer(new Operation<Container>(){
            @Inject
            private Event<StartContainer> event;

            @Override
            public void perform(Container container) {
                this.event.fire((Object)new StartContainer(container));
            }
        });
    }

    public void stopSuiteContainers(@Observes StopSuiteContainers event) throws Exception {
        this.forEachSuiteContainer(new Operation<Container>(){
            @Inject
            private Event<StopContainer> stopContainer;

            @Override
            public void perform(Container container) {
                this.stopContainer.fire((Object)new StopContainer(container));
            }
        });
    }

    public void stopClassContainers(@Observes StopClassContainers event) throws Exception {
        this.forEachClassContainer(new Operation<Container>(){
            @Inject
            private Event<StopContainer> stopContainer;

            @Override
            public void perform(Container container) {
                this.stopContainer.fire((Object)new StopContainer(container));
            }
        });
    }

    public void stopManualContainers(@Observes StopManualContainers event) throws Exception {
        this.forEachManualContainer(new Operation<Container>(){
            @Inject
            private Event<StopContainer> stopContainer;

            @Override
            public void perform(Container container) {
                this.stopContainer.fire((Object)new StopContainer(container));
            }
        });
    }

    public void setupContainer(@Observes SetupContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){

            @Override
            public void perform(Container container) throws Exception {
                container.setup();
            }
        });
    }

    public void startContainer(@Observes StartContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){

            @Override
            public void perform(Container container) throws Exception {
                if (!container.getState().equals((Object)Container.State.STARTED)) {
                    container.start();
                }
            }
        });
    }

    public void stopContainer(@Observes StopContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){

            @Override
            public void perform(Container container) throws Exception {
                if (container.getState().equals((Object)Container.State.STARTED)) {
                    container.stop();
                }
            }
        });
    }

    public void killContainer(@Observes KillContainer event) throws Exception {
        this.forContainer(event.getContainer(), new Operation<Container>(){

            @Override
            public void perform(Container container) throws Exception {
                if (container.getState().equals((Object)Container.State.STARTED)) {
                    container.kill();
                }
            }
        });
    }

    private void forEachContainer(Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            return;
        }
        for (Container container : registry.getContainers()) {
            operation.perform(container);
        }
    }

    private void forEachSuiteContainer(Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        for (Container container : registry.getContainers()) {
            if (!"suite".equals(container.getContainerConfiguration().getMode())) continue;
            operation.perform(container);
        }
    }

    private void forEachClassContainer(Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        for (Container container : registry.getContainers()) {
            if (!"class".equals(container.getContainerConfiguration().getMode())) continue;
            operation.perform(container);
        }
    }

    private void forEachManualContainer(Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        for (Container container : registry.getContainers()) {
            if (!"manual".equals(container.getContainerConfiguration().getMode())) continue;
            operation.perform(container);
        }
    }

    private void forContainer(Container container, Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        operation.perform(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operation<T> {
        public void perform(T var1) throws Exception;
    }
}

