/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;

public class DeploymentScenario {
    private final List<Deployment> deployments = new ArrayList<Deployment>();

    public DeploymentScenario addDeployment(DeploymentDescription deployment) {
        Validate.notNull(deployment, "Deployment must be specified");
        this.deployments.add(new Deployment(deployment));
        return this;
    }

    public Set<TargetDescription> targets() {
        HashSet<TargetDescription> targets = new HashSet<TargetDescription>();
        for (Deployment dep : this.deployments) {
            targets.add(dep.getDescription().getTarget());
        }
        return targets;
    }

    public Set<ProtocolDescription> protocols() {
        HashSet<ProtocolDescription> protocols = new HashSet<ProtocolDescription>();
        for (Deployment dep : this.deployments) {
            protocols.add(dep.getDescription().getProtocol());
        }
        return protocols;
    }

    public Deployment deployment(DeploymentTargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        if (DeploymentTargetDescription.DEFAULT.equals(target)) {
            return this.findDefaultDeployment();
        }
        return this.findMatchingDeployment(target);
    }

    private Deployment findDefaultDeployment() {
        if (this.deployments.size() == 1) {
            return this.deployments.get(0);
        }
        if (this.deployments.size() > 1) {
            if (this.archiveDeploymentCount() == 1) {
                for (Deployment deployment : this.deployments) {
                    if (!deployment.getDescription().isArchiveDeployment()) continue;
                    return deployment;
                }
            }
            if (this.managedDeploymentCount() == 1) {
                for (Deployment deployment : this.deployments) {
                    if (!deployment.getDescription().managed()) continue;
                    return deployment;
                }
            }
        }
        return null;
    }

    private int managedDeploymentCount() {
        int count = 0;
        for (Deployment deployment : this.deployments) {
            if (!deployment.getDescription().managed()) continue;
            ++count;
        }
        return count;
    }

    private int archiveDeploymentCount() {
        int count = 0;
        for (Deployment deployment : this.deployments) {
            if (!deployment.getDescription().isArchiveDeployment()) continue;
            ++count;
        }
        return count;
    }

    private Deployment findMatchingDeployment(DeploymentTargetDescription target) {
        for (Deployment deployment : this.deployments) {
            if (!deployment.getDescription().getName().equals(target.getName())) continue;
            return deployment;
        }
        return null;
    }

    public List<Deployment> managedDeploymentsInDeployOrder() {
        ArrayList<Deployment> managedDeployment = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            DeploymentDescription desc = deployment.getDescription();
            if (!desc.managed()) continue;
            managedDeployment.add(deployment);
        }
        Collections.sort(managedDeployment, new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return new Integer(o1.getDescription().getOrder()).compareTo(o2.getDescription().getOrder());
            }
        });
        return Collections.unmodifiableList(managedDeployment);
    }

    public List<Deployment> deployedDeploymentsInUnDeployOrder() {
        ArrayList<Deployment> managedDeployment = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            DeploymentDescription desc = deployment.getDescription();
            if (!desc.managed() && !deployment.isDeployed()) continue;
            managedDeployment.add(deployment);
        }
        Collections.sort(managedDeployment, new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return new Integer(o2.getDescription().getOrder()).compareTo(o1.getDescription().getOrder());
            }
        });
        return Collections.unmodifiableList(managedDeployment);
    }

    public List<Deployment> startupDeploymentsFor(TargetDescription target) {
        Validate.notNull(target, "Target must be specified");
        ArrayList<Deployment> startupDeployments = new ArrayList<Deployment>();
        for (Deployment deployment : this.deployments) {
            DeploymentDescription desc = deployment.getDescription();
            if (!desc.managed() || !target.equals(desc.getTarget())) continue;
            startupDeployments.add(deployment);
        }
        Collections.sort(startupDeployments, new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return new Integer(o1.getDescription().getOrder()).compareTo(o2.getDescription().getOrder());
            }
        });
        return Collections.unmodifiableList(startupDeployments);
    }

    public List<Deployment> deploymentsInError() {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (Deployment dep : this.deployments) {
            if (!dep.hasDeploymentError()) continue;
            result.add(dep);
        }
        return result;
    }

    public List<Deployment> deployedDeployments() {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (Deployment dep : this.deployments) {
            if (!dep.isDeployed()) continue;
            result.add(dep);
        }
        return result;
    }

    public List<Deployment> deployments() {
        return Collections.unmodifiableList(this.deployments);
    }
}

