/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.container;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.event.ContainerMultiControlEvent;
import org.jboss.arquillian.container.spi.event.StartManagedContainers;
import org.jboss.arquillian.container.spi.event.StopManagedContainers;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class ContainerRestarter {
    private int testClassesCount = 0;
    @Inject
    private Event<ContainerMultiControlEvent> controlEvent;
    @Inject
    private Instance<ArquillianDescriptor> configuration;

    public void restart(@Observes BeforeClass event) throws Exception {
        if (this.shouldRestart()) {
            this.controlEvent.fire((Object)new StopManagedContainers());
            this.controlEvent.fire((Object)new StartManagedContainers());
        }
    }

    private boolean shouldRestart() {
        ArquillianDescriptor descriptor = (ArquillianDescriptor)this.configuration.get();
        Integer maxTestClasses = descriptor.engine().getMaxTestClassesBeforeRestart();
        if (maxTestClasses == null) {
            return false;
        }
        if (maxTestClasses > -1 && maxTestClasses - 1 == this.testClassesCount) {
            this.testClassesCount = 0;
            return true;
        }
        ++this.testClassesCount;
        return false;
    }
}

