/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.execution;

import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.container.test.impl.execution.event.ExecutionEvent;
import org.jboss.arquillian.container.test.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.container.test.impl.execution.event.RemoteExecutionEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.Test;

public class ClientTestExecuter {
    @Inject
    private Event<ExecutionEvent> executionEvent;
    @Inject
    private Instance<DeploymentDescription> deploymentDescription;

    public void execute(@Observes Test event) throws Exception {
        boolean runAsClient = true;
        DeploymentDescription deploymentDescription = (DeploymentDescription)this.deploymentDescription.get();
        if (deploymentDescription != null) {
            boolean bl = runAsClient = !deploymentDescription.testable();
            if (event.getTestMethod().isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            } else if (event.getTestClass().isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            }
        }
        if (runAsClient) {
            this.executionEvent.fire((Object)new LocalExecutionEvent(event.getTestMethodExecutor()));
        } else {
            this.executionEvent.fire((Object)new RemoteExecutionEvent(event.getTestMethodExecutor()));
        }
    }
}

