/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010 Red Hat Inc. and/or its affiliates and other contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.util.logging.Logger;

/**
 * ThreadContext
 *
 * @author <a href="mailto:aslak@redhat.com">Aslak Knutsen</a>
 * @version $Revision: $
 */
public class ThreadContext
{
   private static ThreadLocal<ClassLoader> previousClassloader = new ThreadLocal<ClassLoader>();
   
   private static Logger log = Logger.getLogger(ThreadContext.class.getName());
   
   public static void set(ClassLoader classLoader)
   {
      if(previousClassloader.get() != null)
      {
         log.warning("Attempting to set a new Thread Context ClassLoader without the old one being reset: " + previousClassloader.get());
      }
      previousClassloader.set(Thread.currentThread().getContextClassLoader());
      Thread.currentThread().setContextClassLoader(classLoader);
   }
   
   public static void reset()
   {
      if(previousClassloader.get() == null)
      {
         log.warning("Attempting to reset the Thread Context ClassLoader without one being set");
      }
      else
      {
         Thread.currentThread().setContextClassLoader(previousClassloader.get());
         previousClassloader.set(null);
      }
   }
   
}
