/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client;

import java.lang.reflect.Method;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.context.DeploymentContext;
import org.jboss.arquillian.container.spi.event.ContainerMultiControlEvent;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.SetupContainers;
import org.jboss.arquillian.container.spi.event.StartClassContainers;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopClassContainers;
import org.jboss.arquillian.container.spi.event.StopManualContainers;
import org.jboss.arquillian.container.spi.event.StopSuiteContainers;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.AfterTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.Test;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerEventController {
    @Inject
    private Instance<ContainerContext> containerContext;
    @Inject
    private Instance<DeploymentContext> deploymentContext;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;
    @Inject
    private Event<ContainerMultiControlEvent> container;
    @Inject
    private Event<GenerateDeployment> deployment;

    public void execute(@Observes BeforeSuite event) {
        this.container.fire((Object)new SetupContainers());
        this.container.fire((Object)new StartSuiteContainers());
    }

    public void execute(@Observes AfterSuite event) {
        this.container.fire((Object)new StopSuiteContainers());
    }

    public void execute(@Observes BeforeClass event) {
        this.container.fire((Object)new StartClassContainers());
        this.deployment.fire((Object)new GenerateDeployment(event.getTestClass()));
        this.container.fire((Object)new DeployManagedDeployments());
    }

    public void execute(@Observes AfterClass event) {
        try {
            this.container.fire((Object)new UnDeployManagedDeployments());
        }
        finally {
            this.container.fire((Object)new StopManualContainers());
            this.container.fire((Object)new StopClassContainers());
        }
    }

    public void createBeforeContext(@Observes EventContext<BeforeTestLifecycleEvent> context) {
        this.createContext(context);
    }

    public void createTestContext(@Observes EventContext<Test> context) {
        this.createContext(context);
    }

    public void createAfterContext(@Observes EventContext<AfterTestLifecycleEvent> context) {
        this.createContext(context);
    }

    private void createContext(EventContext<? extends TestEvent> context) {
        try {
            this.lookup(((TestEvent)context.getEvent()).getTestMethod(), new Activate());
            context.proceed();
        }
        finally {
            this.lookup(((TestEvent)context.getEvent()).getTestMethod(), new DeActivate());
        }
    }

    private void lookup(Method method, ResultCallback callback) {
        DeploymentTargetDescription deploymentTarget = this.locateDeployment(method);
        ContainerRegistry containerRegistry = (ContainerRegistry)this.containerRegistry.get();
        DeploymentScenario deploymentScenario = (DeploymentScenario)this.deploymentScenario.get();
        org.jboss.arquillian.container.spi.client.deployment.Deployment deployment = deploymentScenario.deployment(deploymentTarget);
        if (deployment == null && deploymentTarget != DeploymentTargetDescription.DEFAULT) {
            throw new IllegalStateException("No deployment found in " + DeploymentScenario.class.getSimpleName() + " for defined target: " + deploymentTarget.getName() + ". Please verify that the @" + OperateOnDeployment.class.getSimpleName() + " annotation on method " + method.getName() + " match a defined @" + Deployment.class.getSimpleName() + ".name");
        }
        if (deployment != null) {
            Container container = containerRegistry.getContainer(deployment.getDescription().getTarget());
            callback.call(container, deployment);
        }
    }

    private DeploymentTargetDescription locateDeployment(Method method) {
        DeploymentTargetDescription target = null;
        target = method.isAnnotationPresent(OperateOnDeployment.class) ? new DeploymentTargetDescription(method.getAnnotation(OperateOnDeployment.class).value()) : DeploymentTargetDescription.DEFAULT;
        return target;
    }

    private class DeActivate
    extends ResultCallback {
        private DeActivate() {
        }

        void call(Container container, org.jboss.arquillian.container.spi.client.deployment.Deployment deployment) {
            ((ContainerContext)ContainerEventController.this.containerContext.get()).deactivate();
            ((DeploymentContext)ContainerEventController.this.deploymentContext.get()).deactivate();
        }
    }

    private class Activate
    extends ResultCallback {
        private Activate() {
        }

        void call(Container container, org.jboss.arquillian.container.spi.client.deployment.Deployment deployment) {
            ((ContainerContext)ContainerEventController.this.containerContext.get()).activate((Object)container.getName());
            ((DeploymentContext)ContainerEventController.this.deploymentContext.get()).activate((Object)deployment);
        }
    }

    private abstract class ResultCallback {
        private ResultCallback() {
        }

        abstract void call(Container var1, org.jboss.arquillian.container.spi.client.deployment.Deployment var2);
    }
}

