/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.embedded_3_1;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.container.glassfish.embedded_3_1.InstallRootFilter;
import org.jboss.arquillian.container.glassfish.embedded_3_1.InstanceRootFilter;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishConfiguration
implements ContainerConfiguration {
    private int bindHttpPort = 8181;
    private String instanceRoot = null;
    private String installRoot = null;
    private boolean configurationReadOnly = true;
    private String configurationXml;
    private String resourcesXml;
    private boolean cleanup = true;

    public void validate() throws ConfigurationException {
        new GlassFishConfigProcessor().processConfig();
    }

    public int getBindHttpPort() {
        return this.bindHttpPort;
    }

    public void setBindHttpPort(int bindHttpPort) {
        this.bindHttpPort = bindHttpPort;
    }

    public String getInstanceRoot() {
        return this.instanceRoot;
    }

    public void setInstanceRoot(String instanceRoot) {
        this.instanceRoot = instanceRoot;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    public boolean isConfigurationReadOnly() {
        return this.configurationReadOnly;
    }

    public void setConfigurationReadOnly(boolean configurationReadOnly) {
        this.configurationReadOnly = configurationReadOnly;
    }

    public String getConfigurationXml() {
        return this.configurationXml;
    }

    public void setConfigurationXml(String configurationXml) {
        this.configurationXml = configurationXml;
    }

    public boolean getCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public List<String> getResourcesXml() {
        if (this.resourcesXml == null) {
            return Collections.emptyList();
        }
        ArrayList<String> resources = new ArrayList<String>();
        for (String resource : this.resourcesXml.split(",")) {
            resources.add(resource.trim());
        }
        return resources;
    }

    public void setResourcesXml(String resourcesXml) {
        this.resourcesXml = resourcesXml;
    }

    public List<String> getSunResourcesXml() {
        return this.getResourcesXml();
    }

    public void setSunResourcesXml(String sunResourcesXml) {
        Logger.getLogger(this.getClass().getName()).warning("The sunResourcesXml property deprecated. Please use resourcesXml. See http://docs.oracle.com/cd/E18930_01/html/821-2417/giyhh.html");
        this.setResourcesXml(sunResourcesXml);
    }

    class GlassFishConfigProcessor {
        GlassFishConfigProcessor() {
        }

        public void processConfig() throws RuntimeException {
            List<String> resourcesXml;
            if (GlassFishConfiguration.this.installRoot != null) {
                this.verifyInstallRoot(GlassFishConfiguration.this.installRoot);
            }
            if (GlassFishConfiguration.this.instanceRoot != null) {
                if (GlassFishConfiguration.this.configurationXml != null) {
                    this.verifyInstanceRoot(GlassFishConfiguration.this.instanceRoot, false);
                } else {
                    this.verifyInstanceRoot(GlassFishConfiguration.this.instanceRoot, true);
                }
            }
            if (GlassFishConfiguration.this.configurationXml != null) {
                this.verifyConfigurationXml(GlassFishConfiguration.this.configurationXml);
                URI configurationXmlURI = this.convertFilePathToURI(GlassFishConfiguration.this.configurationXml);
                GlassFishConfiguration.this.configurationXml = configurationXmlURI.toString();
            }
            if ((resourcesXml = GlassFishConfiguration.this.getResourcesXml()).size() > 0) {
                for (String resourceXml : resourcesXml) {
                    this.verifyResourcesXml(resourceXml);
                }
            }
        }

        private void verifyInstallRoot(String installRoot) {
            File installRootPath = new File(installRoot);
            if (installRootPath.isDirectory()) {
                File[] requiredDirs = installRootPath.listFiles(new InstallRootFilter());
                if (requiredDirs.length != 2) {
                    throw new RuntimeException("The Glassfish installRoot directory does not appear to be valid. It does not contain the 'domains' and 'lib' sub-directories.");
                }
            } else {
                throw new RuntimeException("The installRoot property should be a directory. Instead, it was a file.");
            }
        }

        private void verifyInstanceRoot(String instanceRoot, boolean ignoreConfigXml) {
            File instanceRootPath = new File(instanceRoot);
            if (instanceRootPath.isDirectory()) {
                File[] requiredDirs = instanceRootPath.listFiles(new InstanceRootFilter(ignoreConfigXml));
                if (requiredDirs.length != 2) {
                    throw new RuntimeException("The Glassfish instanceRoot directory does not appear to be valid. It should contain the 'config' and 'docroot' sub-directories. The 'config' sub-directory must also contain a domain.xml file, if the configurationXml property is ommitted from the arquillian config. Other files specified in domain.xml may also be required for initializing the Glassfish runtime.");
                }
            } else {
                throw new RuntimeException("The instanceRoot property should be a directory. Instead, it was a file.");
            }
        }

        private void verifyConfigurationXml(String configurationXml) {
            try {
                File configXmlPath = new File(configurationXml);
                if (!configXmlPath.exists()) {
                    throw new RuntimeException("The configurationXml property does not appear to be a valid file path.");
                }
                URI configXmlURI = configXmlPath.toURI();
                if (!configXmlURI.isAbsolute()) {
                    throw new RuntimeException("The configurationXml property should contain a URI scheme.");
                }
            }
            catch (IllegalArgumentException argEx) {
                throw new RuntimeException("A valid URI could not be composed from the provided configurationXml property.", argEx);
            }
        }

        private void verifyResourcesXml(String resourcesXml) {
            File resourcesXmlPath = new File(resourcesXml);
            if (!resourcesXmlPath.exists()) {
                throw new RuntimeException("The resourcesXml property does not appear to be a valid file path.");
            }
        }

        private URI convertFilePathToURI(String path) {
            File filePath = new File(path);
            URI filepathURI = filePath.toURI();
            return filepathURI;
        }
    }
}

