/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.embedded_6;

import java.net.URL;
import javax.naming.InitialContext;
import org.jboss.arquillian.container.jbossas.embedded_6.JBossASContainerConfiguration;
import org.jboss.arquillian.container.jbossas.embedded_6.ManagementViewParser;
import org.jboss.arquillian.container.jbossas.embedded_6.ShrinkWrapUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.embedded.api.server.JBossASEmbeddedServer;
import org.jboss.embedded.api.server.JBossASEmbeddedServerFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class JBossASEmbeddedContainer
implements DeployableContainer<JBossASContainerConfiguration> {
    private JBossASEmbeddedServer server;
    private ProfileService profileService;
    private DeploymentManager deploymentManager;
    private InitialContext context;
    private JBossASContainerConfiguration configuration;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public Class<JBossASContainerConfiguration> getConfigurationClass() {
        return JBossASContainerConfiguration.class;
    }

    public void setup(JBossASContainerConfiguration configuration) {
        this.configuration = configuration;
        this.server = JBossASEmbeddedServerFactory.createServer();
        ((JBossASServerConfig)((JBossASServerConfig)this.server.getConfiguration()).bindAddress(configuration.getBindAddress())).serverName(configuration.getProfileName());
    }

    public void start() throws LifecycleException {
        try {
            this.server.start();
            this.initDeploymentManager();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        String deploymentName = descriptor.getDescriptorName();
        URL deploymentUrl = ShrinkWrapUtil.toURL(descriptor);
        this.deploy(deploymentName, deploymentUrl);
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        this.undeploy(descriptor.getDescriptorName());
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = archive.getName();
        URL deploymentUrl = ShrinkWrapUtil.toURL(archive);
        this.deploy(deploymentName, deploymentUrl);
        try {
            return ManagementViewParser.parse(archive.getName(), (ProfileService)new InitialContext().lookup("ProfileService"));
        }
        catch (Exception e) {
            throw new DeploymentException("Could not extract deployment metadata", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.undeploy(archive.getName());
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy from container", (Throwable)e);
        }
    }

    private void initDeploymentManager() throws Exception {
        String profileName = this.configuration.getProfileName();
        InitialContext ctx = this.createContext();
        this.profileService = (ProfileService)ctx.lookup("ProfileService");
        this.deploymentManager = this.profileService.getDeploymentManager();
        ProfileKey defaultKey = new ProfileKey(profileName);
        this.deploymentManager.loadProfile(defaultKey);
    }

    private InitialContext createContext() throws Exception {
        if (this.context == null) {
            this.context = new InitialContext();
        }
        return this.context;
    }

    private void deploy(String deploymentName, URL url) throws DeploymentException {
        Exception failure = null;
        try {
            DeploymentProgress distribute = this.deploymentManager.distribute(deploymentName, url, true);
            distribute.run();
            DeploymentStatus uploadStatus = distribute.getDeploymentStatus();
            if (uploadStatus.isFailed()) {
                failure = uploadStatus.getFailure();
                this.undeploy(deploymentName);
            } else {
                DeploymentProgress progress = this.deploymentManager.start(new String[]{deploymentName});
                progress.run();
                DeploymentStatus status = progress.getDeploymentStatus();
                if (status.isFailed()) {
                    failure = status.getFailure();
                    this.undeploy(deploymentName);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + deploymentName, (Throwable)e);
        }
        if (failure != null) {
            throw new DeploymentException("Failed to deploy " + deploymentName, (Throwable)failure);
        }
    }

    private void undeploy(String name) throws DeploymentException {
        try {
            DeploymentProgress stopProgress = this.deploymentManager.stop(new String[]{name});
            stopProgress.run();
            DeploymentProgress undeployProgress = this.deploymentManager.remove(new String[]{name});
            undeployProgress.run();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + name, (Throwable)e);
        }
    }
}

