/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.managed_6;

import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.deployment.Validate;

public class JBossASConfiguration
implements ContainerConfiguration {
    private String bindAddress = "localhost";
    private int httpPort = 8080;
    private int rmiPort = 1099;
    private String profileName = "default";
    private boolean useRmiPortForAliveCheck = false;
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String javaVmArguments = "-Xmx512m -XX:MaxPermSize=128m";
    private int startupTimeoutInSeconds = 120;
    private int shutdownTimeoutInSeconds = 45;

    public void validate() throws ConfigurationException {
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)"Either JBOSS_HOME environment variable or jbossHome property in Arquillian configuration must be set and point to a valid directory");
        Validate.configurationDirectoryExists((String)this.javaHome, (String)"Either JAVA_HOME environment variable or javaHome property in Arquillian configuration must be set and point to a valid directory");
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void setUseRmiPortForAliveCheck(boolean checkAliveUsingRmiPort) {
        this.useRmiPortForAliveCheck = checkAliveUsingRmiPort;
    }

    public boolean isUseRmiPortForAliveCheck() {
        return this.useRmiPortForAliveCheck;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getJbossHome() {
        if (this.jbossHome != null) {
            return new File(this.jbossHome).getAbsolutePath();
        }
        return this.jbossHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getShutdownTimeoutInSeconds() {
        return this.shutdownTimeoutInSeconds;
    }

    public void setShutdownTimeoutInSeconds(int shutdownTimeoutInSeconds) {
        this.shutdownTimeoutInSeconds = shutdownTimeoutInSeconds;
    }
}

