/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.openejb.embedded_3_1;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import org.apache.openejb.assembler.classic.AppInfo;
import org.jboss.arquillian.container.openejb.embedded_3_1.SecurityActions;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.prototyping.context.api.ArquillianContext;
import org.jboss.arquillian.prototyping.context.api.Properties;
import org.jboss.arquillian.prototyping.context.api.Property;
import org.jboss.arquillian.prototyping.context.impl.PropertiesImpl;
import org.jboss.arquillian.prototyping.context.impl.openejb.OpenEJBArquillianContextImpl;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBTestEnricher
implements TestEnricher {
    private static final String ANNOTATION_NAME = "javax.ejb.EJB";
    @org.jboss.arquillian.core.api.annotation.Inject
    private Instance<AppInfo> appInfo;
    private ArquillianContext arquillianContext = null;

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME)) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    protected List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must be specified");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation must be specified");
        }
        return SecurityActions.getFieldsWithAnnotation(clazz, annotation);
    }

    protected void injectClass(Object testCase) {
        try {
            Class<?> ejbAnnotation = SecurityActions.getThreadContextClassLoader().loadClass(ANNOTATION_NAME);
            List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (final Field field : annotatedFields) {
                if (field.get(testCase) != null) continue;
                EJB fieldAnnotation = (EJB)field.getAnnotation(ejbAnnotation);
                Object ejb = this.lookupEJB(field.getType(), fieldAnnotation.mappedName());
                field.set(testCase, ejb);
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Method method : methods) {
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("@EJB only allowed on single argument methods");
                }
                if (!method.getName().startsWith("set")) {
                    throw new RuntimeException("@EJB only allowed on 'set' methods");
                }
                EJB parameterAnnotation = null;
                for (Annotation annotation : method.getParameterAnnotations()[0]) {
                    if (!EJB.class.isAssignableFrom(annotation.annotationType())) continue;
                    parameterAnnotation = (EJB)annotation;
                }
                String mappedName = parameterAnnotation == null ? null : parameterAnnotation.mappedName();
                Object ejb = this.lookupEJB(method.getParameterTypes()[0], mappedName);
                method.invoke(testCase, ejb);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
        Class<Inject> inject = Inject.class;
        List<Field> fieldsWithInject = this.getFieldsWithAnnotation(testCase.getClass(), inject);
        for (final Field field : fieldsWithInject) {
            if (!field.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
            }
            try {
                Object resolvedVaue;
                ArquillianContext arquillianContext = this.getArquillianContext();
                Class<?> type = field.getType();
                if (field.isAnnotationPresent(Properties.class)) {
                    Properties properties = field.getAnnotation(Properties.class);
                    resolvedVaue = arquillianContext.get(type, properties);
                } else if (field.isAnnotationPresent(Property.class)) {
                    Property property = field.getAnnotation(Property.class);
                    PropertiesImpl properties = new PropertiesImpl(new Property[]{property});
                    resolvedVaue = arquillianContext.get(type, properties);
                } else {
                    resolvedVaue = arquillianContext.get(type);
                }
                field.set(testCase, resolvedVaue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not inject into " + field.getName() + " of test case: " + testCase, e);
            }
        }
    }

    protected Context createContext() throws Exception {
        return this.getArquillianContext().get(InitialContext.class);
    }

    protected ArquillianContext getArquillianContext() {
        if (this.arquillianContext == null) {
            AppInfo deployment = (AppInfo)this.appInfo.get();
            this.arquillianContext = new OpenEJBArquillianContextImpl(deployment);
        }
        return this.arquillianContext;
    }

    protected Object lookupEJB(Class<?> fieldType, String mappedName) throws Exception {
        Context initcontext = this.createContext();
        if (mappedName != null && !mappedName.equals("")) {
            return initcontext.lookup(mappedName);
        }
        return this.lookupRecursive(fieldType, initcontext, initcontext.listBindings("/"));
    }

    protected Object lookupRecursive(Class<?> fieldType, Context context, NamingEnumeration<Binding> contextNames) throws Exception {
        while (contextNames.hasMore()) {
            Binding contextName = (Binding)contextNames.nextElement();
            Object value = contextName.getObject();
            if (Context.class.isInstance(value)) {
                Context subContext = (Context)value;
                return this.lookupRecursive(fieldType, subContext, subContext.listBindings("/"));
            }
            value = context.lookup(contextName.getName());
            if (!fieldType.isInstance(value)) continue;
            return value;
        }
        throw new RuntimeException("Could not lookup EJB reference for: " + fieldType);
    }
}

