/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.tomcat.Validate;

public class CommonTomcatConfiguration
implements ContainerConfiguration {
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private String bindAddress = "localhost";
    private int bindHttpPort = 8080;
    private String user;
    private String pass;
    private int jmxPort = 8089;
    private String jmxVirtualHost = "localhost";
    private String urlCharset = "ISO-8859-1";
    private String appBase = "webapps";
    private boolean unpackArchive = false;
    private URI jmxUri;
    private URL managerUrl;

    public void validate() throws ConfigurationException {
        Validate.notNullOrEmpty(this.bindAddress, "Bind address must not be null or empty");
        Validate.isInRange(this.jmxPort, 0, 65535, "JMX port must be in interval ]0,65535[, but was " + this.jmxPort);
        try {
            this.setJmxUri(this.createJmxUri());
            this.setManagerUrl(this.createManagerUrl());
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException("JMX URI is not valid, please provide ", (Throwable)ex);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("JMX URI is not valid", (Throwable)e);
        }
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getBindHttpPort() {
        return this.bindHttpPort;
    }

    public void setBindHttpPort(int bindHttpPort) {
        this.bindHttpPort = bindHttpPort;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        this.appBase = appBase;
    }

    public boolean isUnpackArchive() {
        return this.unpackArchive;
    }

    public void setUnpackArchive(boolean unpackArchive) {
        this.unpackArchive = unpackArchive;
    }

    public void setUrlCharset(String urlCharset) {
        this.urlCharset = urlCharset;
    }

    public String getUrlCharset() {
        return this.urlCharset;
    }

    public void setJmxVirtualHost(String jmxVirtualHost) {
        this.jmxVirtualHost = jmxVirtualHost;
    }

    public String getJmxVirtualHost() {
        return this.jmxVirtualHost;
    }

    public void setJmxUri(URI jmxUri) {
        this.jmxUri = jmxUri;
    }

    public URI getJmxUri() {
        return this.jmxUri;
    }

    public void setManagerUrl(URL managerUrl) {
        this.managerUrl = managerUrl;
    }

    public URL getManagerUrl() {
        return this.managerUrl;
    }

    protected URI createJmxUri() throws URISyntaxException {
        String template = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
        return new URI(String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", this.bindAddress, this.jmxPort));
    }

    protected URL createManagerUrl() throws MalformedURLException {
        String template = "http://%s:%d/manager";
        return new URL(String.format("http://%s:%d/manager", this.bindAddress, this.bindHttpPort));
    }
}

