/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.embedded_7;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.xml.sax.InputSource;

public class EmbeddedContextConfig
extends ContextConfig {
    private static final Log log = LogFactory.getLog(EmbeddedContextConfig.class);

    protected void webConfig() {
        this.applicationContextConfig();
        super.webConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applicationContextConfig() {
        ServletContext servletContext = this.context.getServletContext();
        InputStream stream = servletContext.getResourceAsStream("/META-INF/context.xml");
        if (stream == null) {
            return;
        }
        Digester digester = contextDigester;
        synchronized (digester) {
            URL url = null;
            try {
                url = servletContext.getResource("/META-INF/context.xml");
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)"/META-INF/context.xml should not be considered a malformed URL");
            }
            InputSource is = new InputSource(url.toExternalForm());
            is.setByteStream(stream);
            contextDigester.push((Object)this.context);
            try {
                contextDigester.parse(is);
            }
            catch (Exception e) {
                this.ok = false;
                log.error((Object)("Parse error in context.xml for " + this.context.getName()), (Throwable)e);
            }
            finally {
                contextDigester.reset();
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Error closing context.xml for " + this.context.getName()), (Throwable)e);
                }
            }
        }
        log.debug((Object)"Done processing META-INF/context.xml descriptor");
    }

    protected void fixDocBase() throws IOException {
        super.fixDocBase();
        this.originalDocBase = this.context.getDocBase();
    }
}

