/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.se.embedded_1.shrinkwrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.container.weld.se.embedded_1.shrinkwrap.ShrinkwrapBeanDeploymentArchive;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkwrapBeanDeploymentArchiveImpl
implements ShrinkwrapBeanDeploymentArchive,
Assignable {
    private Archive<?> archive;
    private ServiceRegistry serviceRegistry = new SimpleServiceRegistry();
    private ShrinkWrapClassLoader classLoader;

    public ShrinkwrapBeanDeploymentArchiveImpl(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        this.archive = archive;
        this.classLoader = new ShrinkWrapClassLoader(archive.getClass().getClassLoader(), new Archive[]{archive});
    }

    protected Archive<?> getArchive() {
        return this.archive;
    }

    @Override
    public ShrinkWrapClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Collection<URL> getBeansXml() {
        ArrayList<URL> beanClasses = new ArrayList<URL>();
        Map classes = this.archive.getContent(Filters.include((String)".*/beans.xml"));
        for (final Map.Entry entry : classes.entrySet()) {
            try {
                beanClasses.add(new URL(null, "archive://" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            public void connect() throws IOException {
                            }

                            public InputStream getInputStream() throws IOException {
                                return ((Node)entry.getValue()).getAsset().openStream();
                            }
                        };
                    }
                }));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return beanClasses;
    }

    public Collection<Class<?>> getBeanClasses() {
        ArrayList beanClasses = new ArrayList();
        Map classes = this.archive.getContent(Filters.include((String)".*\\.class"));
        try {
            for (Map.Entry classEntry : classes.entrySet()) {
                Class loadedClass = this.getClassLoader().loadClass(this.getClassName((ArchivePath)classEntry.getKey()));
                beanClasses.add(loadedClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class from archive " + this.archive.getName(), e);
        }
        return beanClasses;
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.emptySet();
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.emptySet();
    }

    public String getId() {
        return this.archive.getName();
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public String getClassName(ArchivePath path) {
        String className = path.get();
        if (className.charAt(0) == '/') {
            className = className.substring(1);
        }
        className = className.replaceAll("\\.class", "");
        className = className.replaceAll("/", ".");
        return className;
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        return (TYPE)this.getArchive().as(clazz);
    }
}

